/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import java.util.Arrays;
import org.genepattern.modules.Chip2ChipWrapper;
import org.genepattern.modules.CollapseDatasetWrapper;
import org.genepattern.modules.GseaPrerankedWrapper;
import org.genepattern.modules.GseaWrapper;
import org.genepattern.modules.LeadingEdgeToolWrapper;

public class CLI {
    private static final String USAGE_MESSAGE = "Usage: operationName followed by operation-specific arguments where operationName is one of GSEA, GSEAPreranked, CollapseDataset, Chip2Chip, or LeadingEdgeTool";

    public static void main(String[] args) throws Exception {
        String[] operationArgs;
        if (args == null || args.length == 0) {
            System.err.println(USAGE_MESSAGE);
            System.exit(1);
        }
        String operationName = args[0];
        String[] stringArray = operationArgs = args.length == 1 ? new String[]{} : Arrays.copyOfRange(args, 1, args.length);
        if ("GSEA".equalsIgnoreCase(operationName)) {
            GseaWrapper.main(operationArgs);
        } else if ("GSEAPreranked".equalsIgnoreCase(operationName)) {
            GseaPrerankedWrapper.main(operationArgs);
        } else if ("CollapseDataset".equalsIgnoreCase(operationName)) {
            CollapseDatasetWrapper.main(operationArgs);
        } else if ("Chip2Chip".equalsIgnoreCase(operationName)) {
            Chip2ChipWrapper.main(operationArgs);
        } else if ("LeadingEdgeTool".equalsIgnoreCase(operationName)) {
            LeadingEdgeToolWrapper.main(operationArgs);
        } else {
            throw new Exception("Usage: unrecognized operationName " + operationName + "\nUsage: operationName followed by operation-specific arguments where operationName is one of GSEA, GSEAPreranked, CollapseDataset, Chip2Chip, or LeadingEdgeTool");
        }
    }
}

