/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;

public class IntegerRange
extends AbstractNumericRange<Integer> {
    protected int _min;
    protected int _max;

    public IntegerRange() {
        this(0, 1);
    }

    public IntegerRange(int n, int n2) {
        this._min = Math.min(n, n2);
        this._max = Math.max(n, n2);
    }

    public IntegerRange(IntegerRange integerRange) {
        this((int)integerRange.minimum(), (int)integerRange.maximum());
    }

    @Override
    public Range<Integer> copy() {
        return new IntegerRange(this);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public int getMin() {
        return this._min;
    }

    public void setMin(int n) {
        int n2 = this._min;
        if (n2 == n) {
            return;
        }
        assert (n <= this._max) : "minimum " + n + " not <= " + this._max;
        this._min = n;
        this.firePropertyChange("min", n2, n);
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int n) {
        int n2 = this._max;
        if (n2 == n) {
            return;
        }
        assert (n >= this._min) : "maximum " + n + " not >= " + this._min;
        this._max = n;
        this.firePropertyChange("max", n2, n);
    }

    @Override
    public void adjust(Integer n, Integer n2) {
        double d = this.size();
        if (n != null) {
            this.setMin(n);
        } else if (n2 != null) {
            this.setMin(n2 - (int)d);
        }
        if (n2 != null) {
            this.setMax(n2);
        } else if (n != null) {
            this.setMin(n + (int)d);
        }
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Integer lower() {
        return (int)this.minimum();
    }

    @Override
    public Integer upper() {
        return (int)this.maximum();
    }

    @Override
    public boolean contains(Integer n) {
        return n >= this._min && n <= this._max;
    }

    @Override
    public Range<Integer> createIntermediate(Range<Integer> range, double d) {
        double d2 = this.minimum();
        double d3 = this.maximum();
        double d4 = range.minimum();
        double d5 = range.maximum();
        double d6 = d2 + d * (d4 - d2);
        double d7 = d3 + d * (d5 - d3);
        return new IntegerRange((int)Math.round(d6), (int)Math.round(d7));
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerRange) {
            IntegerRange integerRange = (IntegerRange)object;
            return this._min == integerRange._min && this._max == integerRange._max;
        }
        return false;
    }

    public int hashCode() {
        return this._max * 29 + this._min;
    }

    public String toString() {
        return String.format("#<IntegerRange min=%d max=%d>", this._min, this._max);
    }
}

