/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.parallelcolt;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import java.util.HashSet;
import java.util.Iterator;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.util.CoordinateSetToLongWrapper;
import org.ujmp.core.util.MathUtil;
import org.ujmp.parallelcolt.ParallelColtDenseDoubleMatrix2D;
import org.ujmp.parallelcolt.ParallelColtSparseDoubleMatrix2DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelColtSparseDoubleMatrix2D
extends AbstractSparseDoubleMatrix2D
implements Wrapper<SparseDoubleMatrix2D> {
    private static final long serialVersionUID = -3223474248020842822L;
    public static final ParallelColtSparseDoubleMatrix2DFactory Factory = new ParallelColtSparseDoubleMatrix2DFactory();
    private final SparseDoubleMatrix2D matrix;

    public ParallelColtSparseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = new SparseDoubleMatrix2D(rows, columns);
    }

    public ParallelColtSparseDoubleMatrix2D(SparseDoubleMatrix2D m) {
        super((long)m.rows(), (long)m.columns());
        this.matrix = m;
    }

    public ParallelColtSparseDoubleMatrix2D(Matrix source) {
        this(MathUtil.longToInt(source.getRowCount()), MathUtil.longToInt(source.getColumnCount()));
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
        if (source.getMetaData() != null) {
            this.setMetaData(source.getMetaData().clone());
        }
    }

    @Override
    public final void clear() {
        this.matrix.elements().clear();
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getQuick((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getQuick(row, column);
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setQuick((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setQuick(row, column, value);
    }

    @Override
    public SparseDoubleMatrix2D getWrappedObject() {
        return this.matrix;
    }

    @Override
    public Matrix inv() {
        return new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)new DenseDoubleAlgebra().inverse((DoubleMatrix2D)this.matrix));
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new AvailableCoordinateIterable();
    }

    @Override
    public final boolean containsCoordinates(long ... coordinates) {
        return this.getAsDouble(coordinates) != 0.0;
    }

    public ParallelColtSparseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AvailableCoordinateIterable
    implements Iterable<long[]> {
        AvailableCoordinateIterable() {
        }

        @Override
        public Iterator<long[]> iterator() {
            HashSet<Coordinates> cset = new HashSet<Coordinates>();
            for (long r = ParallelColtSparseDoubleMatrix2D.this.getRowCount() - 1L; r >= 0L; --r) {
                for (long c = ParallelColtSparseDoubleMatrix2D.this.getColumnCount() - 1L; c >= 0L; --c) {
                    if (ParallelColtSparseDoubleMatrix2D.this.getDouble(r, c) == 0.0) continue;
                    cset.add(Coordinates.wrap(r, c).clone());
                }
            }
            return new CoordinateSetToLongWrapper(cset).iterator();
        }
    }
}

