/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.elasticsearch;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.search.SearchHit;
import org.ujmp.core.mapmatrix.AbstractMapMatrix;
import org.ujmp.core.util.StringUtil;
import org.ujmp.elasticsearch.ElasticsearchIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElasticsearchSample
extends AbstractMapMatrix<String, Object> {
    private static final long serialVersionUID = -9091555583281035794L;
    public static final String ID = "_id";
    public static final String SCORE = "score";
    private final ElasticsearchIndex elasticsearchIndex;
    private final Map<String, Object> map;

    public ElasticsearchSample(ElasticsearchIndex elasticsearchIndex) {
        this.elasticsearchIndex = elasticsearchIndex;
        this.map = new TreeMap<String, Object>();
    }

    public ElasticsearchSample(ElasticsearchIndex elasticsearchIndex, Map<String, Object> source) {
        this.elasticsearchIndex = elasticsearchIndex;
        this.map = source;
        this.setId(StringUtil.getString(this.map.get(ID)));
    }

    public ElasticsearchSample(ElasticsearchIndex elasticsearchIndex, SearchHit hit) {
        this.elasticsearchIndex = elasticsearchIndex;
        this.setId(hit.getId());
        System.out.println(this.getId());
        this.map = hit.getSource() != null ? hit.getSource() : new TreeMap<String, Object>();
        this.setScore(hit.getScore());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    protected void clearMap() {
        this.elasticsearchIndex.remove(this.get(ID));
        this.map.clear();
    }

    @Override
    protected Object removeFromMap(Object key) {
        Object old = this.map.remove(key);
        this.elasticsearchIndex.put(this);
        return old;
    }

    @Override
    protected Object putIntoMap(String key, Object value) {
        Object old = this.map.put(key, value);
        if (!SCORE.equals(key)) {
            this.elasticsearchIndex.put(this);
        }
        return old;
    }

    public double getScore() {
        return this.getMetaDataDouble(SCORE);
    }

    public void setScore(double score) {
        this.setMetaData(SCORE, score);
    }

    public ElasticsearchIndex getIndex() {
        return this.elasticsearchIndex;
    }
}

