/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AbstractFTPInputStream;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class FTPASCIIInputStream
extends AbstractFTPInputStream {
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    private byte[] buffer;
    private int bufpos = 0;
    private int buflen = 0;
    private byte[] chunk;
    private byte[] prevBuf = new byte[FTPClient.FTP_LINE_SEPARATOR.length];
    private int matchpos = 0;
    private ByteArrayOutputStream out;

    public FTPASCIIInputStream(FTPClient client, String remoteFile) throws IOException, FTPException {
        this(client, remoteFile, 0L);
    }

    public FTPASCIIInputStream(FTPClient client, String remoteFile, long offset) throws IOException, FTPException {
        super(client, remoteFile);
        this.chunk = new byte[client.getTransferBufferSize()];
        this.out = new ByteArrayOutputStream(client.getTransferBufferSize());
    }

    public int read() throws IOException {
        if (!this.started) {
            this.start();
        }
        if (this.buffer == null) {
            return -1;
        }
        if (this.bufpos == this.buflen) {
            this.buffer = this.refreshBuffer();
            if (this.buffer == null) {
                return -1;
            }
        }
        return 0xFF & this.buffer[this.bufpos++];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.started) {
            this.start();
        }
        if (this.buffer == null || len == 0) {
            return -1;
        }
        if (this.bufpos == this.buflen) {
            this.buffer = this.refreshBuffer();
            if (this.buffer == null) {
                return -1;
            }
        }
        int available = 0;
        int remaining = len;
        while ((available = this.buflen - this.bufpos) < remaining) {
            System.arraycopy(this.buffer, this.bufpos, b, off, available);
            remaining -= available;
            off += available;
            this.buffer = this.refreshBuffer();
            if (this.buffer != null) continue;
            return len - remaining;
        }
        System.arraycopy(this.buffer, this.bufpos, b, off, remaining);
        this.bufpos += remaining;
        return len;
    }

    protected void start() throws IOException {
        super.start();
        this.buffer = this.refreshBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] refreshBuffer() throws IOException {
        byte[] byArray;
        this.bufpos = 0;
        if (this.client.isTransferCancelled()) {
            return null;
        }
        int count = this.client.readChunk(this.in, this.chunk, this.chunk.length);
        if (count < 0) {
            if (this.matchpos > 0) {
                this.pos += (long)this.matchpos;
                this.buflen = this.matchpos;
                this.monitorCount += (long)this.matchpos;
                byte[] tmp = new byte[this.matchpos];
                System.arraycopy(tmp, 0, this.prevBuf, 0, this.matchpos);
                this.matchpos = 0;
                return tmp;
            }
            return null;
        }
        try {
            this.out.reset();
            for (int i = 0; i < count; ++i) {
                if (this.chunk[i] == FTPClient.FTP_LINE_SEPARATOR[this.matchpos]) {
                    this.prevBuf[this.matchpos] = this.chunk[i];
                    ++this.matchpos;
                    if (this.matchpos != FTPClient.FTP_LINE_SEPARATOR.length) continue;
                    this.out.write(LINE_SEPARATOR);
                    this.pos += (long)LINE_SEPARATOR.length;
                    this.monitorCount += (long)LINE_SEPARATOR.length;
                    this.matchpos = 0;
                    continue;
                }
                if (this.matchpos > 0) {
                    this.out.write(this.prevBuf, 0, this.matchpos);
                    this.pos += (long)this.matchpos;
                    this.monitorCount += (long)this.matchpos;
                }
                this.out.write(this.chunk[i]);
                ++this.pos;
                ++this.monitorCount;
                this.matchpos = 0;
            }
            byte[] result = this.out.toByteArray();
            this.buflen = result.length;
            byArray = result;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.checkMonitor();
            throw throwable;
        }
        this.checkMonitor();
        return byArray;
    }
}

