/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

public class IntelligentFileReader
extends Reader {
    private static final Logger logger = Logger.getLogger(IntelligentFileReader.class.getName());
    private FileReader fr = null;
    private InputStream is = null;
    private LineNumberReader lr = null;
    private String encoding = "UTF-8";

    public IntelligentFileReader(String file) {
        this(new File(file));
    }

    public IntelligentFileReader(InputStream inputStream) {
        try {
            this.lr = new LineNumberReader(new InputStreamReader(inputStream, this.encoding));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "could not open stream", e);
        }
    }

    public IntelligentFileReader(Reader reader) {
        try {
            this.lr = new LineNumberReader(reader);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "could not open stream", e);
        }
    }

    public IntelligentFileReader(File file) {
        this(file, "UTF-8");
    }

    public IntelligentFileReader(File file, String encoding) {
        this.encoding = encoding;
        if (file != null && file.exists()) {
            if (file.getAbsolutePath().toLowerCase().endsWith(".gz")) {
                try {
                    this.is = new GZIPInputStream(new FileInputStream(file));
                    this.lr = new LineNumberReader(new InputStreamReader(this.is, encoding));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "could not open file " + file, e);
                }
            } else if (file.getAbsolutePath().toLowerCase().endsWith(".z")) {
                try {
                    this.is = new ZipInputStream(new FileInputStream(file));
                    this.lr = new LineNumberReader(new InputStreamReader(this.is, encoding));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "could not open file " + file, e);
                }
            } else {
                try {
                    this.is = new FileInputStream(file);
                    this.lr = new LineNumberReader(new InputStreamReader(this.is, encoding));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "could not open file " + file, e);
                }
            }
        } else {
            logger.log(Level.WARNING, "cannot open file: " + file);
        }
    }

    public IntelligentFileReader(URLConnection connection) throws IOException {
        this(connection.getInputStream());
    }

    public String readLine() {
        if (this.lr == null) {
            return null;
        }
        try {
            return this.lr.readLine();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "could not read line", e);
            return null;
        }
    }

    public void close() {
        try {
            if (this.lr != null) {
                this.lr.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.fr != null) {
                this.fr.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getLineNumber() {
        if (this.lr != null) {
            return this.lr.getLineNumber();
        }
        return -1;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.lr.read(cbuf, off, len);
    }

    public static String load(String filename) {
        StringBuilder s = new StringBuilder();
        IntelligentFileReader fr = new IntelligentFileReader(filename);
        String line = null;
        while ((line = fr.readLine()) != null) {
            s.append(line + "\n");
        }
        fr.close();
        return s.toString();
    }

    public static String load(File filename) {
        StringBuilder s = new StringBuilder();
        IntelligentFileReader fr = new IntelligentFileReader(filename);
        String line = null;
        while ((line = fr.readLine()) != null) {
            s.append(line + "\n");
        }
        fr.close();
        return s.toString();
    }

    public static String load(InputStream stream) {
        StringBuilder s = new StringBuilder();
        IntelligentFileReader fr = new IntelligentFileReader(stream);
        String line = null;
        while ((line = fr.readLine()) != null) {
            s.append(line + "\n");
        }
        fr.close();
        return s.toString();
    }

    public static String load(Reader reader) {
        StringBuilder s = new StringBuilder();
        IntelligentFileReader fr = new IntelligentFileReader(reader);
        String line = null;
        while ((line = fr.readLine()) != null) {
            s.append(line + "\n");
        }
        fr.close();
        return s.toString();
    }

    public static byte[] readBytes(File file) {
        return IntelligentFileReader.readBytes(file, MathUtil.longToInt(file.length()));
    }

    public static byte[] readBytes(File file, int length) {
        try {
            VerifyUtil.verifyNotNull(file, "file is null");
            VerifyUtil.verifyFalse(file.isDirectory(), "file is a directory");
            VerifyUtil.verifyTrue(file.canRead(), "cannot read from file");
            byte[] data = new byte[MathUtil.longToInt(Math.min(file.length(), (long)length))];
            FileInputStream fi = new FileInputStream(file);
            BufferedInputStream bi = new BufferedInputStream(fi);
            bi.read(data);
            bi.close();
            fi.close();
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String load(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setConnectTimeout(3000);
        return IntelligentFileReader.load(connection.getInputStream());
    }
}

