/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.util.MathUtil;

public class DiscretizeToColumns
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -3606534079672701424L;
    private long column = 0L;
    private List<Object> values = null;
    private boolean ignoreNaN = false;
    private long[] size;

    public DiscretizeToColumns(Matrix matrix, boolean ignoreNaN, long column) {
        super(matrix);
        this.column = column;
        this.ignoreNaN = ignoreNaN;
        this.countValues();
    }

    public long[] getSize() {
        return this.size;
    }

    public double getDouble(long ... coordinates) {
        long col;
        this.countValues();
        if (coordinates[1] < this.column) {
            return this.getSource().getAsDouble(coordinates);
        }
        if (coordinates[1] >= this.column + (long)this.values.size()) {
            long col2 = coordinates[1] - (long)this.values.size() + 1L;
            return this.getSource().getAsDouble(coordinates[0], col2);
        }
        Object o = this.getSource().getAsObject(coordinates[0], this.column);
        if (this.ignoreNaN) {
            long col3;
            if (MathUtil.isNaNOrInfinite(o)) {
                return 0.0;
            }
            int index = this.values.indexOf(o);
            if ((long)index == (col3 = coordinates[1] - this.column)) {
                return 1.0;
            }
            return 0.0;
        }
        if (MathUtil.isNaNOrInfinite(o)) {
            return Double.NaN;
        }
        int index = this.values.indexOf(o);
        if ((long)index == (col = coordinates[1] - this.column)) {
            return 1.0;
        }
        return 0.0;
    }

    private void countValues() {
        if (this.values == null) {
            TreeSet<Object> set = new TreeSet<Object>();
            long row = this.getSource().getRowCount();
            while (--row >= 0L) {
                Object o = this.getSource().getAsObject(row, this.column);
                if (this.ignoreNaN) {
                    if (MathUtil.isNaNOrInfinite(o)) {
                        set.add(0.0);
                        continue;
                    }
                    set.add(o);
                    continue;
                }
                if (MathUtil.isNaNOrInfinite(o)) continue;
                set.add(o);
            }
            this.values = new ArrayList<Object>(set);
        }
        this.size = Coordinates.copyOf(this.getSource().getSize());
        this.size[1] = this.size[1] + (long)(this.values.size() - 1);
    }
}

