@q file: runtime_env.w@>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>
@** Yacco2 global variables.\fbreak
A hodge-podge of entities and procedures supporting tracing, files processed with
 recursion support,
threading tables and their first sets,
 low-level character mapping, and low level mutual exclusion controlling
 access to
threads, tracing, and symbol table management.

Access control: Bouncer / doorman.\fbreak
By their name |TRACE_MU|, |MUTEX TH_TBL_MU|, and |MUTEX SYM_TBL_MU|
are mutexes for crowd control for tracing, thread table management, 
and symbol table access.
|THDS_STABLE__| and |THDS_FSET_BY_T__| are data structures generated by
Yacco2's Linker that get resolved to the specific use of this library. 
They are dangling references.

File management:\fbreak
|FILE_TBL__| is a dictionary of file names that 
have been opened during the compile process.
It's key is the file number component to the symbol's GPS in the source file.
|FILE_CNT__| is the current file number being processed.
It starts from 0 due to \CPLUSPLUS/'s vector requirement used by |FILE_TBL__|.
The |tok_can| template containers use these variables: ie,
raw character symbol processing.
|STK_FILE_NOS__| is a stack of nested |FILE_CNT__| file numbers
used to re-establish processing of the file following its include statement.   

@<Type...@>+=
typedef std::vector<std::string> gbl_file_map_type;

@*2 Global variables.
@<Global variables@>+=
extern std::list<std::string> O2_LOGICALS__;
extern std::ofstream lrclog;
extern std::ofstream lrerrors;
extern yacco2::KCHARP Lr1_VERSION;
extern yacco2::KCHARP O2linker_VERSION;
extern yacco2::MUTEX TRACE_MU;
extern yacco2::MUTEX TH_TBL_MU;
extern yacco2::MUTEX SYM_TBL_MU;
extern yacco2::MUTEX TOKEN_MU;
extern yacco2::gbl_file_map_type FILE_TBL__;
extern yacco2::UINT FILE_CNT__;
extern std::vector<yacco2::UINT> STK_FILE_NOS__;
struct rc_map;
extern yacco2::rc_map RC__;


@ |LRK_LA_EOLR_SET|. \fbreak
Used by |find_reduce_entry| for meta termials lookahed set.
Meta-terminals are 8 elements that start off the enumeration scheme. 
  Therefore they all fit within one partition.
\QUEshift, eog, and \PARshift{} are left out of the lookahead set
leaving eolr, \INVshift, \ALLshift,\PROCshift, and \REDshift.

@<Global variables@>+=  
extern yacco2::Set_entry LRK_LA_EOLR_SET;

@ |LRK_LA_QUE_SET| for error enforcement. \fbreak
Used by |find_questionable_sym_in_reduce_lookahead| 
for forced reduce to handle error detection.
It forces the reducing subrule to reduce cuz the
\QUEshift{} symbol in in its follow set.
That is the shifted into parse state for the recuded rule
contains the \QUEshift{} symbol used for error catching.
@<Global variables@>+=  
extern yacco2::Set_entry LRK_LA_QUE_SET;

@*2 Global routines.
@<External rtns and variables@>+=
extern void Delete_tokens(yacco2::TOKEN_GAGGLE& Tks,bool Do_delete=OFF);
extern void Clear_yacco2_opened_files_dictionary();


@*2 Global variables implementations.
@<accrue yacco2 code@>=
std::list<std::string> yacco2::O2_LOGICALS__;
yacco2::gbl_file_map_type yacco2::FILE_TBL__;
std::vector<yacco2::UINT> yacco2::STK_FILE_NOS__;
yacco2::UINT yacco2::FILE_CNT__(0);
yacco2::rc_map yacco2::RC__;
yacco2::Type_pp_fnct_ptr yacco2::PTR_AR_for_manual_thread_spawning(0);
// split lines: cuz Apple's latest compiler bug 
// No matching literal operator for call to 'operator"' date macro 
// with arguments of types 'const char*' and 'unsigned long', and no matching literal operator template 
// 
yacco2::KCHARP 
yacco2::Lr1_VERSION = "O2 version: 1.0 Distribution Date: "@/
 __DATE__ "\n";
yacco2::KCHARP 
yacco2::O2linker_VERSION = "O2linker version: 1.0 Distribution Date: "@/
__DATE__ "\n";

yacco2::MUTEX yacco2::TOKEN_MU;
yacco2::MUTEX yacco2::TRACE_MU;
yacco2::MUTEX yacco2::TH_TBL_MU;
yacco2::MUTEX yacco2::SYM_TBL_MU;
std::ofstream yacco2::lrclog("1lrtracings.log");
std::ofstream yacco2::lrerrors("1lrerrors.log");
yacco2::Set_entry 
yacco2::LRK_LA_EOLR_SET 
 = {0,0xf4};// eolr, \REDshift, \INVshift, \ALLshift, and \PROCshift 
yacco2::Set_entry 
yacco2::LRK_LA_QUE_SET 
 = {0,0x01};// elem 1 is \QUEshift so |2^0|

@*2 Runtime errors.\fbreak
It supplies all the error objects that get thrown
within yacco2's environment. 
Presently, my design is crude: no design but a list of error events.

@<Struct...@>+=
struct Source_info{
   Source_info(yacco2::KCHARP File,yacco2::UINT Line);
   void w_info();
   yacco2::KCHARP file__;
   yacco2::INT line__;
};
struct Yacco2_faulty_precondition:Source_info{
   Yacco2_faulty_precondition(yacco2::KCHARP Message
                                ,yacco2::KCHARP File = __FILE__
                                ,yacco2::UINT Line = __LINE__);
};

struct Yacco2_faulty_postcondition:Source_info{
    Yacco2_faulty_postcondition(yacco2::KCHARP Message
                                  ,yacco2::KCHARP File = __FILE__
                                  ,yacco2::UINT Line = __LINE__);
};

@*2 Runtime error messages implementations. 
@<accrue yacco2 code@>=
   yacco2::
   Source_info::@/
   Source_info(yacco2::KCHARP File,yacco2::UINT Line)
           :file__(File)
           ,line__(Line){
           w_info();
           }
           
   void 
   yacco2::
   Source_info::@/
   w_info(){
           yacco2::lrclog
           << " Version: " << yacco2::Lr1_VERSION
           << " thrown from source file: " << file__
           << " line: " << line__
           << __FILE__ << __LINE__<< std::endl;
           std::cout
           << " Version: " << yacco2::Lr1_VERSION
           << " thrown from source file: " << file__
           << " line: " << line__
           << __FILE__ << __LINE__<< std::endl;
   }

   yacco2::
   Yacco2_faulty_precondition::@/
   Yacco2_faulty_precondition(yacco2::KCHARP Message
                                ,yacco2::KCHARP File
                                ,yacco2::UINT Line)@/
                                :Source_info(File,Line){
    yacco2::lrclog << "Yacco2_faulty_precondition: " << Message << ' ' << __FILE__ << ": " << __LINE__<< std::endl;
    std::cout << "Yacco2_faulty_precondition: " << Message << std::endl;
  }

    yacco2::
    Yacco2_faulty_postcondition::@/
    Yacco2_faulty_postcondition(yacco2::KCHARP Message
                                  ,yacco2::KCHARP File
                                  ,yacco2::UINT Line)@/
                                  :Source_info(File,Line){
      yacco2::lrclog << "Yacco2_faulty_postcondition: " << Message << ' '<< __FILE__ << ": " << __LINE__<< std::endl;
      std::cout << "Yacco2_faulty_postcondition: " << Message << std::endl;
    }


@*2 Global garbage sweeper.\fbreak
Simple container whose contents are deleted.
As one parses, somewhere the newly minted tokens needed to be deleted.
The container maintains a one-to-one reference to the symbol which gets
deleted by this routine.
Due to the ``lr k symbols'' being globally defined in global space rather
than being their creation by the new operator, 
there is protective code to prevent their deletion.

Depending on how the ``Raw Characters'' are built, they could also be bypassed.
For now, the ``global garbage'' sweeper is not very good: a map template just is down
right slow. So I must revisit my thought and come up with a better data structure to
use.

I bypass this routine as the cost of building
the thread index is TOOOOOooo slow and occassionally buggy from
the template implementation.
@^MSN bug pranks.@>
@<Type...@>+=
typedef std::set < yacco2::CAbs_lr1_sym* > set_of_objs_type;
typedef set_of_objs_type::iterator set_of_objs_iter_type;

@*2 |Delete_tokens|.
@<accrue yacco2 code@>=
extern
void yacco2::Delete_tokens(yacco2::TOKEN_GAGGLE& Tks,bool Do_delete){@/
return;
using namespace NS_yacco2_k_symbols;
static yacco2::set_of_objs_type deleted_syms;
static yacco2::set_of_objs_type dont_delete_syms;
static bool onetime(OFF);
if(onetime == OFF){
  onetime = ON;
  dont_delete_syms.insert(PTR_LR1_eolr__);
  dont_delete_syms.insert(PTR_LR1_questionable_shift_operator__);
  dont_delete_syms.insert(PTR_LR1_eog__);
  dont_delete_syms.insert(PTR_LR1_parallel_operator__);
  dont_delete_syms.insert(PTR_LR1_invisible_shift_operator__);
  dont_delete_syms.insert(PTR_LR1_all_shift_operator__);
  dont_delete_syms.insert(PTR_LR1_fset_transience_operator__);
}
  if(Do_delete == ON){
	  set_of_objs_iter_type k = deleted_syms.begin();
	  set_of_objs_iter_type ke = deleted_syms.end();
	  for(;k!=ke;++k){
	    CAbs_lr1_sym* sym = *k;
		///|delete sym;|
	  }
	  return;
  }
  TOKEN_GAGGLE_ITER i = Tks.begin();
  TOKEN_GAGGLE_ITER ie = Tks.end();
  for(;i != ie;++i){
    yacco2::CAbs_lr1_sym* sym = *i;
	yacco2::set_of_objs_iter_type j;
	j = deleted_syms.find(sym);
	if(j != deleted_syms.end()) continue;//already deleted
	j = dont_delete_syms.find(sym);
	if(j != dont_delete_syms.end()) continue;
	deleted_syms.insert(sym);
  }
}

@*2 |Clear_yacco2_opened_files_dictionary|.\fbreak
Allows one to have multiple parse sessions.
This clears the previous parse attempt.
Give me an example of why u need this?
Consider a XML language recognizer that is continuously being called to process a
say Soap session.
Each session is a new parsing bout.
@<accrue yacco2 code@>=
extern
void yacco2::Clear_yacco2_opened_files_dictionary(){@/
 yacco2::FILE_TBL__.clear();
 yacco2::STK_FILE_NOS__.clear();
 yacco2::FILE_CNT__ = 0;

}
