/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:       xc_str.lex
Dates:      17 Juin 2003
Purpose:	double quoted string with no escape seq. 
Returned:	T_xc_str
            Err_bad_eos - meta terminal indicating an improper end-of-string 
                              this occurs on eof,eog, or an eol terminal ending the string
Note:       Stripped of its double quotes for ease of use    
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |xc_str| Thread.\fbreak
Doubled quoted string without the escape sequences.
@/
fsm	
(fsm-id	"xc_str.lex",fsm-filename xc_str,fsm-namespace NS_xc_str
,fsm-class		Cxc_str {
  user-declaration
    public: 
    char ddd_[1024*32];
    int ddd_idx_;
    void copy_str_into_buffer(std::string* Str);
    void copy_kstr_into_buffer(const char* Str);
  ***
  user-implementation
    void Cxc_str::copy_str_into_buffer(std::string* Str){   
      const char* y = Str->c_str(); 
      int x(0);
      for(;y[x]!=0;++x,++ddd_idx_)ddd_[ddd_idx_] = y[x];
      ddd_[ddd_idx_] = 0;
    }
    void Cxc_str::copy_kstr_into_buffer(const char* Str){
      const char* y = Str; 
      int x(0);
      for(;y[x]!=0;++x,++ddd_idx_)ddd_[ddd_idx_] = y[x];
      ddd_[ddd_idx_] = 0;
    }
  ***
  constructor
    ddd_idx_ = 0;
    ddd_[ddd_idx_] = 0;
 ***
  op
    ddd_idx_ = 0;
    ddd_[ddd_idx_] = 0;
  ***
}
,fsm-version	"1.0"	,fsm-date		"27 Juin 2005"
,fsm-debug		"false"	
,fsm-comments	"No escape sequence check: accept all characters between dbl. quoted string.")
parallel-parser	
(	
  parallel-thread-function
    TH_xc_str
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rxc_str
/@
Use of \invisibleshift to lower the number of members in the lookahead set.
@/ 
()
{	
  -> Rquote |.| {
  op
    Cxc_str* fsm = (Cxc_str*) rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* sym = new T_xc_str((const char*)&fsm->ddd_);
    sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
    sym->set_line_no_and_pos_in_line(*rule_info__.parser__->start_token__);
    RSVP(sym);
  ***
  }
}

Rquote (){
  -> "\"" {
  /@
 Mpost weakness in literal form so substitute the double quote for
``char(34)'' in diagram. The finite state automata recognition is to lower 
the push / pop lr1 activity as this is a lexical automata. 
  @/
  
    op		
	  Cxc_str* fsm = (Cxc_str*) rule_info__.parser__->fsm_tbl__;
loop:
	  switch (rule_info__.parser__->current_token()->enumerated_id__){
	  case T_Enum::T_raw_lf_: goto overrun;
	  case T_Enum::T_raw_cr_: goto overrun;
	  case T_Enum::T_LR1_eog_: goto overrun;	
	  case T_Enum::T_raw_dbl_quote_: goto dblquote;
          default: goto other;
          }
    dblquote:{ // end of string
          rule_info__.parser__->get_next_token();
        if(rule_info__.parser__->current_token()->enumerated_id__ 
            == T_Enum::T_raw_dbl_quote_){
        fsm->copy_kstr_into_buffer("\"");// due to lex scanner
        fsm->copy_kstr_into_buffer("\"");
           rule_info__.parser__->get_next_token();
           goto loop;
        }
        return;// end of c string
    }
    overrun:{
      CAbs_lr1_sym* sym = new Err_bad_eos;
      sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
      sym->set_line_no_and_pos_in_line(*rule_info__.parser__->start_token__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);
      return;
    }
    other:{
        fsm->copy_kstr_into_buffer(rule_info__.parser__->current_token()->id__);
          rule_info__.parser__->get_next_token();
goto loop;
      }
    ***
    }
}

}// end of rules
