/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:    link_cleanser.lex
dates:   15 Mar 2005	
Purpose: Lexical Phase for Linker
Use:     throw out the chaffe like comments eol etc.
         the downstream phase per language deals with its syntax.
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |link_cleanser| grammar.\fbreak
Lexical Phase for Linker.
This is a front end to \O2's linker. 
It throws out the chaffe
and puts the balance into a holding container for 
parsing.
This is my old style of parsing
but now the 2 stages has been brought into 1 stage like |pass3|.
It use to be |pass1|..|pass3| grammars.
@/

fsm	
(fsm-id "link_cleanser.lex",fsm-filename link_cleanser,fsm-namespace NS_link_cleanser
,fsm-class Clink_cleanser{
  user-prefix-declaration
#include "linker_id.h"
#include "ws.h"
#include "c_comments.h"
#include "c_string.h"
#include "bad_char_set.h"
#include "eol.h"
#include "int_no.h"
  ***
  }
,fsm-version	"1.0",fsm-date "17 Apr 2001",fsm-debug "false"
,fsm-comments	"Lexer: \\olinker's cleanser from \n previous lexing to remove chaffe before parsing stage.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rpass3  (
lhs{
  op
    using namespace NS_yacco2_k_symbols;
    ADD_TOKEN_TO_PRODUCER_QUEUE(*yacco2::PTR_LR1_eog__);   
    ADD_TOKEN_TO_PRODUCER_QUEUE(*yacco2::PTR_LR1_eog__);  
  ***
  }
){
  -> eog 
  -> Relems eog
}

Relems  (){
  -> Rtoken
  -> Relems Rtoken
}

Rtoken  (){
  -> ||| ws	NS_ws::TH_ws

  -> ||| "comment" NS_c_comments::TH_c_comments {
    op
      T_comment* k = sf->p2__;
       k->set_auto_delete(true);
    ***
    }
  -> ||| "c-string"	NS_c_string::TH_c_string{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***			
    } 
  -> |+| { // add balance of characters to queue Eg. n or y
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p1__);
    ***			
    } 
  -> ||| "bad eos"	NULL { // 
    op
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
      rule_info__.parser__->set_abort_parse(true);
    ***			
    } 
  -> ||| "identifier"	NS_linker_id::TH_linker_id{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "int-no"	NS_int_no::TH_int_no{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***			
    } 
  -> ||| "comment-overrun"	NULL{
    op
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
      rule_info__.parser__->set_abort_parse(true);
    ***			
    } 
  -> ||| "bad esc"	NULL{
    op
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
      rule_info__.parser__->set_abort_parse(true);
    ***			
    } 
  -> ||| eol	NS_eol::TH_eol
  -> ||| "bad char" NS_bad_char_set::TH_bad_char_set{	
   op
      Err_bad_char* k = sf->p2__;
      ADD_TOKEN_TO_ERROR_QUEUE(*k);
      rule_info__.parser__->set_abort_parse(true);
    ***
    }
  -> ||| "T-in-stbl" NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "th-in-stbl" NULL{
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "kw-in-stbl" NULL{
    op
      kw_in_stbl* kw = sf->p2__;
      CAbs_lr1_sym* sym = kw->keyword_in_stbl();
      sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sym);
    ***
    }
  -> ||| |+| NULL {// keywords
    op
      ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
    ***
  }
}
}// end of rules
