/*##############################################################################

FUNNNELWEB COPYRIGHT
====================
FunnelWeb is a literate-programming macro preprocessor.

Copyright (C) 1992 Ross N. Williams.

   Ross N. Williams
   ross@spam.adelaide.edu.au
   16 Lerwick Avenue, Hazelwood Park 5066, Australia.

This program is free software; you can redistribute it and/or modify
it under the terms of Version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See Version 2 of the GNU General Public License for more details.

You should have received a copy of Version 2 of the GNU General Public
License along with this program. If not, you can FTP the license from
prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Section 2a of the license requires that all changes to this file be
recorded prominently in this file. Please record all changes here.

Programmers:
   RNW  Ross N. Williams  ross@spam.adelaide.edu.au
   ABC  Anthony B. Coates coates@physics.uq.edu.au
   JMS  John Max Skaller  maxtal@suphys.physics.su.edu.au

Changes:
   07-May-1992  RNW  Program prepared for release under GNU GPL V2.
   16-Sep-1993  ABC  Added machine type OSF64 for a 64-bit processor
                     running OSF/1 (particularly the DEC AXP).
   16-Sep-1993  ABC  Changed all constants *_MAX to *_FWMAX to avoid
                     conflict with some standard UNIX constants.
   14-Dec-1993  ABC  Added machine type OS2 for PCs running OS/2 2.1.
   15-Jun-1994  ABC  Added machine type LINUX for PCs running LINUX 1.1.8
   13-Aug-1995  JMS  Added PC32 type for 32-bit DOS-extended code.
   19-Sep-1995  ABC  Set UNIX_EOL to 1 for Unix systems (having
                     removed dependency on this from `mapper.c'.

##############################################################################*/


/******************************************************************************/
/*                                    MACHIN.H                                */
/******************************************************************************/
/*                                                                            */
/* WARNING: DO NOT ADD ANY PROGRAM DEPENDENT DEFINITIONS.                     */
/*                                                                            */
/* This module (machin.h and machin.c) contains definitions and objects       */
/* whose values depends directly on the compilation and execution             */
/* environment, but are otherwise independent from any particular computer    */
/* program.                                                                   */
/*                                                                            */
/* The only difference between the purpose of this module and the "environ"   */
/* module is that the "environ" module contains the "essentials" whereas this */
/* module contains extra machine specific definitions and objects that will   */
/* not be required by most user modules.                                      */
/*                                                                            */
/******************************************************************************/

/* Ensure that the body of this header file is included at most once.         */
#ifndef DONE_MACHIN
#define DONE_MACHIN

/******************************************************************************/

#include <time.h>
#include "style.h"

/******************************************************************************/

/* Machine Alignment Constraints                                              */
/* -----------------------------                                              */
/* Some machines require that objects of particular lengths be aligned in     */
/* memory. For example, the 68000 will trap any attempt to access a word      */
/* (16 bits or an int in THINK C) at an odd address. It is important that C   */
/* programs that deal with memory at a low level be aware of such             */
/* constraints. As the constraints are always at a power of two, we defined   */
/* ALIGN_POWER to be the minimum power of two at which it is both safe and    */
/* efficient to operate.                                                      */

/* The Macintosh requires words and longs to be aligned on word boundaries.   */
/* The PC is not fussy about alignment, but operates more efficiently at word */
/* boundaries.                                                                */
#if MAC | PC
#define ALIGN_POWER (1L)
#endif

/* The Sun requires objects to be aligned on longword boundaries (=2^2).      */
/* The VMS VAX doesn't care about alignment, but operates more efficiently on */
/* longword boundaries.                                                       */
/* OS2, LINUX, and 32-bit DOS code should work better with 32 bit boundaries  */
/* as well [ABC].                                                             */
#if SUN | VMS | PC32 | OS2 | LINUX
#define ALIGN_POWER (2L)
#endif

/* ABC { */
/* 64 bit processors, such as the DEC AXP, require objects to be aligned on   */
/* 64bit boundaries (=2^4).                                                   */
#if OSF64
#define ALIGN_POWER (4L)
#endif
/* } ABC */

/******************************************************************************/

/* Filenames                                                                  */
/* ---------                                                                  */
/* The length and structure of filenames varies from machine to machine. The  */
/* differences addressed here are:                                            */
/*    1) The character used to separate directory specs from filenames.       */
/*    2) The maximum length of a filename.                                    */

/* FN_DELIM must contain the character that separates directory specs from    */
/* filenames. Notice that in the VMS case, it is "]", not "."                 */

#if MAC
#define FN_DELIM ':'
#endif

#if SUN | OSF64 | LINUX
#define FN_DELIM '/'
#endif

#if VAX
#define FN_DELIM ']'
#endif

#if PC | PC32 | OS2
#define FN_DELIM '\\'
#endif

/* The rest of this section shouldn't have to be changed, unless you          */
/* encounter a funny with your system's definition of FILENAME_FWMAX.           */

/* FILENAME_FWMAX tells the maximum number of characters allowed in a filename  */
/* on the target machine. The symbol FILENAME_MAX is supposed to be defined   */
/* in stdio.h (ANSI S7.9.1) so we don't want to override that. However, if it */
/* isn't, we  need to define a safe default length.                           */
/* ABC { */
/* Note that with SysV Unix, `FILENAME_MAX' is the maximum length of the      */
/* filename alone (same as VAX definition mentioned below), without the       */
/* directory path prepended.  The full filename including the directory, has  */
/* a maximum length `PATH_MAX'.                                               */
#ifdef PATH_MAX
#define FILENAME_FWMAX PATH_MAX
#else /* !PATH_MAX */
#ifdef FILENAME_MAX
#define FILENAME_FWMAX FILENAME_MAX
#else /* !FILENAME_MAX */
#define FILENAME_FWMAX 300
#endif /* FILENAME_MAX */
#endif /* PATH_MAX */
/* } ABC */

/* Some VAX compilers define FILENAME_MAX to be 39, which is the maximum      */
/* length of the NAME part of a VMS filename. This is not appropriate, so we  */
/* override it.                                                               */
#if VMS
#undef FILENAME_FWMAX
#define FILENAME_FWMAX 255        /* Should really be NAM$C_MAXRSS              */
#endif

/* ABC { */
/* OS/2 has a 256 character file-name limit (I think). */
#if OS2
#undef FILENAME_FWMAX
#define FILENAME_FWMAX 255
#endif /* OS2 */
/* } ABC */

/* Now we can use the constant to define a filename type.                     */
/* Note: For a while I defined "typedef fn_t *p_fn_t". However, this is a     */
/* pointer to an array rather than (char *) and it caused no end of problems. */
typedef char fn_t[FILENAME_FWMAX+1];
typedef char *p_fn_t;

/******************************************************************************/

/* Command Lines                                                              */
/* -------------                                                              */
/* The maximum length of command line varies from machine to machine and we   */
/* define symbols to reflect this. The reason why we don't just set this to a */
/* high value and forget about it is that FunnelWeb sometimes places          */
/* command line variables on the stack, and some machines (e.g. MAC under     */
/* THINK-C don't provide much stack space. So we have to minimize this        */
/* variable on those machines.                                                */

/* We choose a small maximum command line on the Macintosh so as to avoid     */
/* chewing up stack space when command lines have to be pushed.               */
#if MAC
#define COMLINE_FWMAX 300
#endif

/* On the Sun, OSF/1, or LINUX machine, 1024 is a normal command line and     */
/* 2048 is safe.                                                              */
#if SUN | OSF64 | LINUX
#define COMLINE_FWMAX 2048
#endif

/* On the VMS, 1024 is usually adequate. */
#if VMS
#define COMLINE_FWMAX 1024
#endif

/* On a PC and for OS/2, we assume this is enough. */
#if PC | PC32 | OS2
#define COMLINE_FWMAX 300
#endif

/* Make sure that the value is not too low. */
/* The value 300 is guaranteed by the command interpreter. */
#if COMLINE_FWMAX < 300
   #error COMLINE_FWMAX must be at least 300.
#endif

/* Now define a type for command lines.                                       */
/* Note: For a while I defined "typedef cl_t *p_cl_t". However, this is a     */
/* pointer to an array rather than (char *) and it caused no end of problems. */
typedef char cl_t[COMLINE_FWMAX+1];
typedef char *p_cl_t;

/******************************************************************************/

/* Line Termination                                                           */
/* ----------------                                                           */

/* FunnelWeb has special-case code to make reading input files faster on      */
/* machines where the format of text files corresponds to the internal C      */
/* text stream model. The UNIX_EOL #define should be activated if and only    */
/* the host environment has text files consisting of a stream of bytes with   */
/* a single LF (ASCII,decimal-10,hex-0A) character being used to terminate    */
/* each line, and no special character to indicate end of file.               */
/* This is the same format as is used in the Unix operating system.           */
/* If you are in doubt about this, play it safe and define your environment   */
/* to be non-Unix, as non-Unix will work on ALL systems (including Unix).     */

#if MAC | VMS | PC | PC32 | OS2
/* These systems do NOT use Unix EOLs. */
#define UNIX_EOL 0
#endif

#if SUN | OSF64 | LINUX
/* ABC { */
#define UNIX_EOL 1
/* } ABC */
#endif

/******************************************************************************/

/* Missing Prototypes                                                         */
/* ----------------                                                           */
/* Compilers that are fussy about prototypes sometimes complain about calls   */
/* to the standard libraries. These declarations solve this problem.          */

#if SUN
int     fclose  P_((FILE *stream));
int     fputs   P_((const char *s, FILE *stream));
int     fputc   P_((int c, FILE *stream));
int     fflush  P_((FILE *stream));
int     remove  P_((const char *filename));
int     rename  P_((const char *oldname, const char *newname));
int     toupper P_((int));
int     sscanf  P_(());
int     fprintf P_(());
int     _filbuf P_(());
void    *memcpy P_((void *s1, void *s2, size_t n));
void    *memset P_((void *s,     int c, size_t n));
int     memcmp  P_((void *s1, void *s2, size_t n));
size_t  fread   P_((void *ptr, size_t size, size_t nobj, FILE *stream));
size_t  fwrite  P_((const void *ptr, size_t size, size_t nobj, FILE *stream));
clock_t clock   P_((void));
time_t  time    P_((time_t *tp));
int     printf  P_(());
#endif /* SUN */

/******************************************************************************/

EXPORT void fn_ins P_((p_fn_t,char *));
/* - The name stands for FileName INSert.                                     */
/* - The first argument must be a pointer to an object of type fn_t           */
/*   (containing an ordinary C character string).                             */
/* - The second argument must be a pointer to an ordinary C character string. */
/* - Both arguments must contain a full, partial, or empty filename spec.     */
/* - We will refer to the arguments as f1 and f2.                             */
/* - If there is a syntax error in either spec, fn_ins does nothing.          */
/* - Otherwise, it:                                                           */
/*      1. Analyses the two filename specifications into filename field .     */
/*      2. Replaces each field in f1 by the corresponding field in f2, but    */
/*         only if the corresponding field in f2 is non-empty.                */
/*      3. Optionally [concession to VMS] it may then replace blank fields    */
/*         in the resulting file spec in f1 by fields from the current        */
/*         global "default" directory spec.                                   */
/* The structure and fields of filenames will vary from machine to machine    */
/* and so this is not important. However, every implementation must structure */
/* the filename so that it will at least RECOGNISE a file extension           */
/* (e.g. ".lis") field.                                                       */

/******************************************************************************/

EXPORT void getcline P_((int,char **,char *));
/* Operating system environments vary a lot in the way in which their command */
/* language interfaces are set up. The approach taken in FunnelWeb is to      */
/* define a "standard" Unix-like command line syntax and then insist that     */
/* other environments deliver such a command line as a single string.         */
/* This function getcline must extract such a standard command line from its  */
/* environment and copy it as a single string of not more than COMLINE_FWMAX  */
/* characters into its third argument. A description of the "standard"        */
/* command line can be found in the options package.                          */
/* The first  argument is given to getcline and is argc from main().          */
/* The second argument is given to getcline and is argv from main().          */
/* These two arguments are given in case getcline needs them to assemble the  */
/* command line (as opposed to calling e.g. VMS CLI routines).                */
/* The third argument is the string into which the result should be placed.   */

/******************************************************************************/

EXPORT float tim_real P_((void));
/* Returns the number of seconds between the present and an unspecified, but  */
/* statically fixed time in the past.                                         */
/* Returns 0.0 if this information is unavailable                             */

EXPORT float tim_cpu P_((void));
/* Returns the number of CPU seconds consumed between the present and an      */
/* unspecified, but statically fixed time in the past.                        */
/* Returns 0.0 if this information is unavailable                             */

/******************************************************************************/

/* For #ifndef preventing multiple inclusion of the body of this header file. */
#endif

/******************************************************************************/
/*                                End of MACHIN.H                             */
/******************************************************************************/
