/*
 * Decompiled with CFR 0.152.
 */
package nts.tfm;

import nts.base.BinFraction;
import nts.base.Dimen;
import nts.base.Num;
import nts.io.CharCode;
import nts.io.CntxLog;
import nts.io.Log;
import nts.io.Name;
import nts.node.BaseFontMetric;
import nts.node.BaseNode;
import nts.node.Box;
import nts.node.BoxSizes;
import nts.node.ChrKernNode;
import nts.node.DiscretionaryNode;
import nts.node.FontMetric;
import nts.node.GlueSetting;
import nts.node.HBoxNode;
import nts.node.MathWordBuilder;
import nts.node.Node;
import nts.node.NodeList;
import nts.node.SettingContext;
import nts.node.TreatNode;
import nts.node.TypeSetter;
import nts.node.VBoxNode;
import nts.node.WordBuilder;
import nts.node.WordRebuilder;
import nts.tfm.FixWord;
import nts.tfm.TeXFm;
import nts.tfm.TeXFontMetric;
import nts.tfm.TeXLigKernBuilder;
import nts.tfm.TeXMathExtFm;
import nts.tfm.TeXMathSymFm;

public class TeXFontMetric
extends BaseFontMetric {
    private static final int[] pTab = new int[30];
    private Name name;
    private TeXFm tfm;
    private Dimen atSize;
    private Name ident;

    public static int numberOfRawDimenPars() {
        return pTab.length;
    }

    public static int rawDimenParNumber(int idx) {
        return pTab[idx];
    }

    private void setTfmParam(int i, int tfmIdx) {
        FixWord param;
        if (tfmIdx >= 0 && tfmIdx < this.tfm.paramCount() && (param = this.tfm.getParam(tfmIdx)) != null) {
            Dimen val = tfmIdx == TeXFm.FP_SLANT ? Dimen.valueOf(param) : this.atSize.times(param);
            this.setDimenParam(i, val);
        }
    }

    public Name getName() {
        return this.name;
    }

    public Dimen getAtSize() {
        return this.atSize;
    }

    public Name getIdent() {
        return this.ident;
    }

    public void setIdent(Name ident) {
        this.ident = ident;
    }

    public int getCheckSum() {
        return this.tfm.getCheckSum();
    }

    public Dimen getDesignSize() {
        return Dimen.valueOf(this.tfm.getDesignSize());
    }

    public void addDescOn(Log log) {
        log.add(this.name);
        if (!this.atSize.equals(this.tfm.getDesignSize())) {
            log.add(" at " + this.atSize + "pt");
        }
    }

    private short indexFrom(char chr) {
        return (short)(chr != '\uffff' ? (int)chr : -1);
    }

    private TeXFm.CharInfo getCharInfo(short index) {
        return index == -1 ? null : this.tfm.getCharInfo(index);
    }

    private TeXFm.CharInfo getCharInfo(CharCode code) {
        char chr = code.toChar();
        return chr != '\uffff' ? this.tfm.getCharInfo((short)chr) : null;
    }

    public Node getCharNode(CharCode code) {
        CharNode charNode;
        TeXFm.CharInfo info = this.getCharInfo(code);
        if (info == null) {
            charNode = null;
        } else {
            TeXFontMetric teXFontMetric = this;
            if (teXFontMetric == null) {
                throw null;
            }
            charNode = teXFontMetric.new CharNode(this.atSize.times(info.getWidth()), this.atSize.times(info.getHeight()), this.atSize.times(info.getDepth()), code);
        }
        return charNode;
    }

    public Dimen getCharWidth(char chr) {
        TeXFm.CharInfo info = this.tfm.getCharInfo((short)chr);
        return info != null ? this.atSize.times(info.getWidth()) : null;
    }

    public WordBuilder getWordBuilder(TreatNode proc, boolean boundary, boolean discretionaries) {
        TeXFontMetric teXFontMetric = this;
        if (teXFontMetric == null) {
            throw null;
        }
        return teXFontMetric.new LigKernBuilder(boundary, proc, discretionaries, true);
    }

    public WordRebuilder getWordRebuilder(TreatNode proc, boolean boundary) {
        TeXFontMetric teXFontMetric = this;
        if (teXFontMetric == null) {
            throw null;
        }
        return teXFontMetric.new LigKernBuilder(boundary, proc);
    }

    public MathWordBuilder getMathWordBuilder(TreatNode proc) {
        TeXFontMetric teXFontMetric = this;
        if (teXFontMetric == null) {
            throw null;
        }
        return teXFontMetric.new MathLigKernBuilder(proc);
    }

    public Node getLargerNode(CharCode code) {
        TeXFm.CharInfo info;
        Node node = null;
        short index = this.indexFrom(code.toChar());
        if (index != -1 && (info = this.tfm.getCharInfo(index)) != null) {
            node = this.largerNode(index, info);
        }
        return node;
    }

    private Node largerNode(short index, TeXFm.CharInfo info) {
        TeXFm.CharInfo nextInfo;
        short nextIndex = info.nextChar();
        if (nextIndex != -1 && (nextInfo = this.tfm.getCharInfo(nextIndex)) != null) {
            index = nextIndex;
            info = nextInfo;
        }
        return this.indexNode(index, info);
    }

    public Node getSufficientNode(CharCode code, Dimen desired) {
        short maxIndex = -1;
        TeXFm.CharInfo maxInfo = null;
        Dimen maxSize = Dimen.ZERO;
        short index = this.indexFrom(code.toChar());
        while (index != -1) {
            TeXFm.CharInfo info = this.tfm.getCharInfo(index);
            if (info == null) break;
            if (info.extRep() != -1) {
                return this.makeExt(info, desired);
            }
            Dimen size = this.heightPlusDepth(info);
            if (size.moreThan(maxSize)) {
                maxIndex = index;
                maxInfo = info;
                maxSize = size;
                if (!size.lessThan(desired)) break;
            }
            index = info.nextChar();
        }
        return maxInfo != null ? this.pretendingCharBox(maxIndex, maxInfo) : null;
    }

    private Node makeExt(TeXFm.CharInfo info, Dimen size) {
        TeXFm.CharInfo topInfo = this.getCharInfo(info.extTop());
        TeXFm.CharInfo midInfo = this.getCharInfo(info.extMid());
        TeXFm.CharInfo botInfo = this.getCharInfo(info.extBot());
        TeXFm.CharInfo repInfo = this.getCharInfo(info.extRep());
        if (repInfo != null) {
            Dimen total = Dimen.ZERO;
            Dimen rep = this.heightPlusDepth(repInfo);
            if (topInfo != null) {
                total = total.plus(this.heightPlusDepth(topInfo));
            }
            if (midInfo != null) {
                total = total.plus(this.heightPlusDepth(midInfo));
                rep = rep.times(2);
            }
            if (botInfo != null) {
                total = total.plus(this.heightPlusDepth(botInfo));
            }
            int cnt = 0;
            if (rep.moreThan(0)) {
                while (total.lessThan(size)) {
                    total = total.plus(rep);
                    ++cnt;
                }
            }
            NodeList list = new NodeList();
            HBoxNode repNode = this.pretendingCharBox(info.extRep(), repInfo);
            if (topInfo != null) {
                list.append(this.pretendingCharBox(info.extTop(), topInfo));
            }
            int i = cnt;
            while (i-- > 0) {
                list.append(repNode);
            }
            if (midInfo != null) {
                list.append(this.pretendingCharBox(info.extMid(), midInfo));
                i = cnt;
                while (i-- > 0) {
                    list.append(repNode);
                }
            }
            if (botInfo != null) {
                list.append(this.pretendingCharBox(info.extBot(), botInfo));
            }
            Dimen height = list.isEmpty() ? Dimen.ZERO : list.nodeAt(0).getHeight();
            Dimen width = this.atSize.times(repInfo.getWidth()).plus(this.atSize.times(repInfo.getItalic()));
            return new VBoxNode(new BoxSizes(height, width, total.minus(height), Dimen.ZERO), GlueSetting.NATURAL, list);
        }
        return null;
    }

    public Box getFittingWidthBox(CharCode code, Dimen desired) {
        TeXFm.CharInfo info;
        HBoxNode box = null;
        short index = this.indexFrom(code.toChar());
        if (index != -1 && (info = this.tfm.getCharInfo(index)) != null) {
            TeXFm.CharInfo maxInfo;
            short maxIndex;
            do {
                maxIndex = index;
                maxInfo = info;
            } while ((index = info.nextChar()) != -1 && (info = this.tfm.getCharInfo(index)) != null && !this.atSize.times(info.getWidth()).moreThan(desired));
            box = this.pretendingCharBox(maxIndex, maxInfo);
        }
        return box;
    }

    public Dimen getKernBetween(CharCode left, CharCode right) {
        FixWord kern;
        TeXFm.LigKern ligKern = this.tfm.getLigKern(this.indexFrom(left.toChar()), this.indexFrom(right.toChar()));
        if (ligKern != null && (kern = ligKern.getKern()) != null) {
            return this.atSize.times(kern);
        }
        return null;
    }

    private Dimen heightPlusDepth(TeXFm.CharInfo info) {
        return this.atSize.times(info.getHeight()).plus(this.atSize.times(info.getDepth()));
    }

    private IndexNode indexNode(short index, TeXFm.CharInfo info) {
        TeXFontMetric teXFontMetric = this;
        if (teXFontMetric == null) {
            throw null;
        }
        return teXFontMetric.new IndexNode(this.atSize.times(info.getWidth()), this.atSize.times(info.getHeight()), this.atSize.times(info.getDepth()), index);
    }

    private HBoxNode pretendingCharBox(short index, TeXFm.CharInfo info) {
        IndexNode node = this.indexNode(index, info);
        Dimen width = node.getWidth();
        Dimen ital = node.getItalCorr();
        if (ital != null) {
            width = width.plus(ital);
        }
        return new HBoxNode(new BoxSizes(node.getHeight(), width, node.getDepth(), node.getLeftX()), GlueSetting.NATURAL, new NodeList(node));
    }

    public TeXFontMetric(Name name, TeXFm tfm, Dimen atSize, Name ident) {
        this.name = name;
        this.tfm = tfm;
        this.atSize = atSize;
        this.ident = ident;
        int i = 0;
        while (i < pTab.length) {
            if (pTab[i] >= 0) {
                this.setTfmParam(i, pTab[i]);
            }
            ++i;
        }
    }

    static {
        int i = 0;
        while (i < pTab.length) {
            TeXFontMetric.pTab[i++] = -1;
        }
        TeXFontMetric.pTab[0] = TeXFm.FP_SLANT;
        TeXFontMetric.pTab[1] = TeXFm.FP_SPACE;
        TeXFontMetric.pTab[2] = TeXFm.FP_STRETCH;
        TeXFontMetric.pTab[3] = TeXFm.FP_SHRINK;
        TeXFontMetric.pTab[4] = TeXFm.FP_X_HEIGHT;
        TeXFontMetric.pTab[5] = TeXFm.FP_QUAD;
        TeXFontMetric.pTab[6] = TeXFm.FP_EXTRA_SPACE;
        TeXFontMetric.pTab[7] = TeXMathSymFm.FP_MATH_X_HEIGHT;
        TeXFontMetric.pTab[8] = TeXMathSymFm.FP_MATH_QUAD;
        TeXFontMetric.pTab[9] = TeXMathSymFm.FP_NUM1;
        TeXFontMetric.pTab[10] = TeXMathSymFm.FP_NUM2;
        TeXFontMetric.pTab[11] = TeXMathSymFm.FP_NUM3;
        TeXFontMetric.pTab[12] = TeXMathSymFm.FP_DENOM1;
        TeXFontMetric.pTab[13] = TeXMathSymFm.FP_DENOM2;
        TeXFontMetric.pTab[14] = TeXMathSymFm.FP_SUP1;
        TeXFontMetric.pTab[15] = TeXMathSymFm.FP_SUP2;
        TeXFontMetric.pTab[16] = TeXMathSymFm.FP_SUP3;
        TeXFontMetric.pTab[17] = TeXMathSymFm.FP_SUB1;
        TeXFontMetric.pTab[18] = TeXMathSymFm.FP_SUB2;
        TeXFontMetric.pTab[19] = TeXMathSymFm.FP_SUP_DROP;
        TeXFontMetric.pTab[20] = TeXMathSymFm.FP_SUB_DROP;
        TeXFontMetric.pTab[21] = TeXMathSymFm.FP_DELIM1;
        TeXFontMetric.pTab[22] = TeXMathSymFm.FP_DELIM2;
        TeXFontMetric.pTab[23] = TeXMathSymFm.FP_AXIS_HEIGHT;
        TeXFontMetric.pTab[24] = TeXMathExtFm.FP_DEFAULT_RULE_THICKNESS;
        TeXFontMetric.pTab[25] = TeXMathExtFm.FP_BIG_OP_SPACING1;
        TeXFontMetric.pTab[26] = TeXMathExtFm.FP_BIG_OP_SPACING2;
        TeXFontMetric.pTab[27] = TeXMathExtFm.FP_BIG_OP_SPACING3;
        TeXFontMetric.pTab[28] = TeXMathExtFm.FP_BIG_OP_SPACING4;
        TeXFontMetric.pTab[29] = TeXMathExtFm.FP_BIG_OP_SPACING5;
    }

    protected abstract class AnyNode
    extends BaseNode {
        private final Dimen width;
        private final Dimen height;
        private final Dimen depth;

        public Dimen getWidth() {
            return this.width;
        }

        public Dimen getLeftX() {
            return Dimen.ZERO;
        }

        public Dimen getHeight() {
            return this.height;
        }

        public Dimen getDepth() {
            return this.depth;
        }

        protected boolean allegedlyVisible() {
            return true;
        }

        public final FontMetric getFontMetric() {
            return TeXFontMetric.this;
        }

        public void addOn(Log log, CntxLog cntx) {
            TeXFontMetric.this.getIdent().addEscapedOn(log);
            log.add(' ');
            this.finishAddOn(log);
        }

        public FontMetric addShortlyOn(Log log, FontMetric metric) {
            if (!TeXFontMetric.this.equals(metric)) {
                TeXFontMetric.this.getIdent().addEscapedOn(log);
                log.add(' ');
                metric = TeXFontMetric.this;
            }
            this.finishShortlyAddOn(log);
            return metric;
        }

        public Dimen getItalCorr() {
            TeXFm.CharInfo info = TeXFontMetric.this.tfm.getCharInfo(this.getIdx());
            return info != null ? TeXFontMetric.this.atSize.times(info.getItalic()) : null;
        }

        public abstract short getIdx();

        public abstract void finishAddOn(Log var1);

        public abstract void finishShortlyAddOn(Log var1);

        public boolean canBePartOfDiscretionary() {
            return true;
        }

        public boolean kernAfterCanBeSpared() {
            return true;
        }

        public FontMetric uniformMetric() {
            return TeXFontMetric.this;
        }

        public byte afterWord() {
            return 1;
        }

        public AnyNode(Dimen w, Dimen h, Dimen d) {
            this.width = w;
            this.height = h;
            this.depth = d;
        }
    }

    protected class CharNode
    extends AnyNode {
        private final CharCode code;

        public short getIdx() {
            return (short)this.code.toChar();
        }

        public void finishAddOn(Log log) {
            log.add(this.code);
        }

        public void finishShortlyAddOn(Log log) {
            log.add(this.code);
        }

        public void typeSet(TypeSetter setter, SettingContext sctx) {
            setter.set(this.code, (FontMetric)TeXFontMetric.this);
        }

        public byte beforeWord() {
            return this.code.toCanonicalLetter() != '\uffff' ? (byte)2 : 1;
        }

        public boolean canBePartOfWord() {
            return this.code.toCanonicalLetter() != '\uffff';
        }

        public void contributeCharCodes(Name.Buffer buf) {
            buf.append(this.code);
        }

        public boolean providesRebuilder(boolean prev) {
            return true;
        }

        public WordRebuilder makeRebuilder(TreatNode proc, boolean prev) {
            LigKernBuilder ligKernBuilder;
            if (prev) {
                TeXFontMetric teXFontMetric = TeXFontMetric.this;
                if (teXFontMetric == null) {
                    throw null;
                }
                ligKernBuilder = teXFontMetric.new LigKernBuilder(null, this.code, proc);
            } else {
                TeXFontMetric teXFontMetric = TeXFontMetric.this;
                if (teXFontMetric == null) {
                    throw null;
                }
                ligKernBuilder = teXFontMetric.new LigKernBuilder(false, proc);
            }
            return ligKernBuilder;
        }

        public String toString() {
            return "Char(" + this.code + ")";
        }

        public CharNode(Dimen w, Dimen h, Dimen d, CharCode c) {
            super(w, h, d);
            this.code = c;
        }
    }

    protected class LigNode
    extends AnyNode {
        private final short index;
        private final Name subst;
        private final boolean leftHit;
        private final boolean rightHit;

        public short getIdx() {
            return this.index;
        }

        public void finishAddOn(Log log) {
            log.add((char)this.index).add(" (ligature ");
            if (this.leftHit) {
                log.add('|');
            }
            log.add(this.subst);
            if (this.rightHit) {
                log.add('|');
            }
            log.add(')');
        }

        public void finishShortlyAddOn(Log log) {
            log.add(this.subst);
        }

        public void typeSet(TypeSetter setter, SettingContext sctx) {
            setter.set((char)this.index, (FontMetric)TeXFontMetric.this);
        }

        public byte beforeWord() {
            return (byte)(this.subst.length() > 0 && this.subst.codeAt(0).toCanonicalLetter() != '\uffff' ? 2 : 1);
        }

        public boolean canBePartOfWord() {
            int i = 0;
            while (i < this.subst.length()) {
                if (this.subst.codeAt(i).toCanonicalLetter() == '\uffff') {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void contributeCharCodes(Name.Buffer buf) {
            buf.append(this.subst);
        }

        public boolean rightBoundary() {
            return this.rightHit;
        }

        public boolean providesRebuilder(boolean prev) {
            return true;
        }

        public WordRebuilder makeRebuilder(TreatNode proc, boolean prev) {
            LigKernBuilder ligKernBuilder;
            if (!prev && !this.leftHit) {
                TeXFontMetric teXFontMetric = TeXFontMetric.this;
                if (teXFontMetric == null) {
                    throw null;
                }
                ligKernBuilder = teXFontMetric.new LigKernBuilder(false, proc);
            } else if (!this.leftHit || prev && this.subst.length() > 0) {
                TeXFontMetric teXFontMetric = TeXFontMetric.this;
                if (teXFontMetric == null) {
                    throw null;
                }
                ligKernBuilder = teXFontMetric.new LigKernBuilder(null, this.index, this.subst, this.leftHit, proc);
            } else {
                TeXFontMetric teXFontMetric = TeXFontMetric.this;
                if (teXFontMetric == null) {
                    throw null;
                }
                ligKernBuilder = teXFontMetric.new LigKernBuilder(true, proc);
            }
            return ligKernBuilder;
        }

        public String toString() {
            return "Lig(" + this.index + "; " + this.subst + "; " + this.leftHit + "; " + this.rightHit + ")";
        }

        public LigNode(Dimen w, Dimen h, Dimen d, short i, Name s, boolean lh, boolean rh) {
            super(w, h, d);
            this.index = i;
            this.subst = s;
            this.leftHit = lh;
            this.rightHit = rh;
        }
    }

    protected class LigKernBuilder
    extends TeXLigKernBuilder {
        protected final TreatNode proc;
        protected final boolean discs;
        protected final boolean zeroKerns;

        protected boolean exists(short index) {
            return TeXFontMetric.this.tfm.getCharInfo(index) != null;
        }

        protected TeXFm.LigKern getLigKern(short left, short right) {
            return TeXFontMetric.this.tfm.getLigKern(left, right);
        }

        protected void makeChar(CharCode code) {
            TeXFm.CharInfo info = TeXFontMetric.this.tfm.getCharInfo((short)code.toChar());
            if (info != null) {
                TeXFontMetric teXFontMetric = TeXFontMetric.this;
                if (teXFontMetric == null) {
                    throw null;
                }
                this.proc.execute(teXFontMetric.new CharNode(TeXFontMetric.this.atSize.times(info.getWidth()), TeXFontMetric.this.atSize.times(info.getHeight()), TeXFontMetric.this.atSize.times(info.getDepth()), code));
            }
            this.makeDisc(code);
        }

        protected void makeLig(short lig, Name subst, boolean lh, boolean rh) {
            int l;
            TeXFm.CharInfo info = TeXFontMetric.this.tfm.getCharInfo(lig);
            if (info != null) {
                TeXFontMetric teXFontMetric = TeXFontMetric.this;
                if (teXFontMetric == null) {
                    throw null;
                }
                this.proc.execute(teXFontMetric.new LigNode(TeXFontMetric.this.atSize.times(info.getWidth()), TeXFontMetric.this.atSize.times(info.getHeight()), TeXFontMetric.this.atSize.times(info.getDepth()), lig, subst, lh, rh));
            }
            if ((l = subst.length()) > 0) {
                this.makeDisc(subst.codeAt(l - 1));
            }
        }

        protected void makeKern(BinFraction kern) {
            Dimen dim = TeXFontMetric.this.atSize.times(kern);
            if (this.zeroKerns || !dim.isZero()) {
                this.proc.execute(new ChrKernNode(dim));
            }
        }

        private void makeDisc(CharCode last) {
            Num num;
            if (this.discs && (num = TeXFontMetric.this.getNumParam(0)) != null && last.match(num)) {
                this.proc.execute(DiscretionaryNode.EMPTY);
            }
        }

        protected Node makeChar(CharCode code, boolean larger) {
            return larger ? TeXFontMetric.this.getLargerNode(code) : TeXFontMetric.this.getCharNode(code);
        }

        protected Node makeLig(short lig, Name subst, boolean lh, boolean rh, boolean larger) {
            throw new RuntimeException("larger ligatures not supported");
        }

        public LigKernBuilder(boolean leftBoundary, TreatNode proc, boolean discs, boolean zeroKerns) {
            super(leftBoundary);
            this.proc = proc;
            this.discs = discs;
            this.zeroKerns = zeroKerns;
        }

        public LigKernBuilder(boolean leftBoundary, TreatNode proc) {
            this(leftBoundary, proc, false, false);
        }

        private LigKernBuilder(CharCode code, TreatNode proc) {
            super(code);
            this.proc = proc;
            this.discs = false;
            this.zeroKerns = false;
        }

        private LigKernBuilder(short index, Name subst, boolean leftHit, TreatNode proc) {
            super(index, subst, leftHit);
            this.proc = proc;
            this.discs = false;
            this.zeroKerns = false;
        }

        /* synthetic */ LigKernBuilder(1 var2_2, CharCode charCode, TreatNode treatNode) {
            this(charCode, treatNode);
        }

        /* synthetic */ LigKernBuilder(2 var2_2, short s, Name name, boolean bl, TreatNode treatNode) {
            this(s, name, bl, treatNode);
        }
    }

    protected class MathLigKernBuilder
    extends LigKernBuilder {
        protected void makeLig(short lig, Name subst, boolean lh, boolean rh) {
            TeXFm.CharInfo info = TeXFontMetric.this.tfm.getCharInfo(lig);
            if (info != null) {
                this.proc.execute(TeXFontMetric.this.indexNode(lig, info));
            }
        }

        protected Node makeLig(short lig, Name subst, boolean lh, boolean rh, boolean larger) {
            Node node = null;
            TeXFm.CharInfo info = TeXFontMetric.this.tfm.getCharInfo(lig);
            if (info != null) {
                node = larger ? TeXFontMetric.this.largerNode(lig, info) : TeXFontMetric.this.indexNode(lig, info);
            }
            return node;
        }

        public MathLigKernBuilder(TreatNode proc) {
            super(false, proc, false, true);
        }
    }

    protected class IndexNode
    extends AnyNode {
        private final short index;

        public short getIdx() {
            return this.index;
        }

        public void finishAddOn(Log log) {
            log.add((char)this.index);
        }

        public void finishShortlyAddOn(Log log) {
            log.add((char)this.index);
        }

        public void typeSet(TypeSetter setter, SettingContext sctx) {
            setter.set((char)this.index, (FontMetric)TeXFontMetric.this);
        }

        public String toString() {
            return "Index(" + this.index + ")";
        }

        public IndexNode(Dimen w, Dimen h, Dimen d, short i) {
            super(w, h, d);
            this.index = i;
        }
    }
}

