const GlbSizeFont : byte = 0;
const GlbMapFont : byte = 0;

{-------------------------------------------------}
{                                                 }
{   This procedure processes option INCLUDECHAR   }
{                                                 }
{-------------------------------------------------}
procedure LIncludeChar(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState;
                var FlIncl : byte; var DefFlIncl : boolean;
                var FlNoNext : boolean; var DefFlNoNext : boolean);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
begin
     RState:=RS;
     {--------- INCLUDECHAR --------------------}
     if NBuf > 0 then
     begin
           ErrorLog('*** Warning : INCLUDECHAR with string parameter');
           LogReadState; FlagError:=true;
     end;

     if RState = OpenBrace then icn:=1
                           else icn:=0;

     while (icn > 0) do
     begin
          RState:=NoCommRead(IDent,NBuf,Buf);
          case RState of
          OpenBrace : begin
              icn:=icn+1;
              ErrorLog('*** Error : INCLUDECHAR cannot have list sub-parameters');
              ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
              LogReadState; FlagError:=true;
          end;
          CloseBrace : begin
              if icn = 1 then
              begin
                  if NBuf > 0 then
                  begin
                       ErrorLog('*** Warning : INCLUDECHAR/'+IDent+' : sub-list is ignored');
                       LogReadState;
                  end;
                  if IDent = 'NONEXTCHAR' then
                  begin
                       FlNoNext:=true;
                       DefFlNoNext:=true;
                  end
                  else if IDent = 'NEXTCHAR' then
                  begin
                       FlNoNext:=false;
                       DefFlNoNext:=true;
                  end
                  else if IDent = 'ALLCHAR' then
                  begin
                       FlIncl:=4;
                       DefFlIncl:=true;
                  end
                  else if IDent = 'LIGTABLE' then
                  begin
                       FlIncl:=3;
                       DefFlIncl:=true;
                  end
                  else if IDent = 'KRNDATA' then
                  begin
                       FlIncl:=2;
                       DefFlIncl:=true;
                  end
                  else if IDent = 'LIGDATA' then
                  begin
                       FlIncl:=1;
                       DefFlIncl:=true;
                  end
                  else if IDent = 'NOLIGTABLE' then
                  begin
                       FlIncl:=0;
                       DefFlIncl:=true;
                  end
                  else begin
                       ErrorLog('*** Error : Unknown parameter INCLUDECHAR/'+IDent+' is ignored');
                       LogReadState; FlagError:=true;
                  end;
              end;
          end;
          CloseLex   : begin
              icn:=icn-1;
          end;
          EndFile    : begin
              ErrorLog('*** Error : Unfinished operator (end-of-file)');
              icn:=0; FlagError:=true;
          end;
          end; {case}
     end; {while}
     {--------- end INCLUDECHAR --------------------}
end; {LSave}


{-------------------------------------------------}
{                                                 }
{   This procedure processes operator OPTION      }
{                                                 }
{-------------------------------------------------}
procedure LOption(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState);
var RState : ReadState;
    icn    : integer;
    IDent,
    ss, sbuf   : string;
    fl1, fl2 : boolean;
begin
     RState:=RS;
     {--------- OPTION --------------------}
     if (NBuf > 0) then
     begin
           ErrorLog('*** Warning : OPTIONS with the string parameter.');
           ErrorLog('              Parameter is ignored.');
           LogReadState;
     end;

     if RState = OpenBrace then icn:=1
                           else icn:=0;
     while (icn > 0) do
     begin
           RState:=NoCommRead(IDent,NBuf,Buf);
           case RState of
           OpenBrace : if IDent = 'INCLUDECHAR' then
           begin
                   LIncludeChar(NBuf, Buf, RState,
                             FlIncludeGlb, fl1,
                             FlNoNextCharGlb, fl2);
           end
           else begin
                ErrorLog('*** Error : Unknown parameter OPTION/'+IDent+' is ignored');
                LogReadState; FlagError:=true;
                SkipOp(RState,Buf);
           end;
           CloseLex   : begin
               icn:=icn-1;
           end;
           EndFile    : begin
               ErrorLog('*** Error : Unfinished operator (end-of-file)');
               icn:=0; FlagError:=true;
           end;
           CloseBrace : if icn = 1 then
           begin
                if (NBuf > 0)
                    and (IDent <> 'TRACE')
                    and (IDent <> 'AUTOTFMCHAR') and (IDent <> 'AUTOTFMMAPCHAR')
                then begin
                     ErrorLog('*** Warning : OPTIONS/'+IDent+' string parameter is ignored');
                     LogReadState;
                end;
                if IDent = 'TRACE' then
                begin
                     if NBuf <= 0 then
                     begin
                          FlTraceLigGlb:=2;
                     end
                     else begin
                          sbuf:=PackBuf(NBuf,Buf);
                          FlTraceLigGlb:=ConvFromByte(sbuf,true);
                          if not (FlTraceLigGlb in [0,1,2,3])
                             then FlTraceLigGlb:=3;
                     end;
                end
                else if IDent = 'NOTRACE'
                     then FlTraceLigGlb:=0
                else if IDent = 'PHANTOM'
                     then FlagNullDVIGlb:=true
                else if (IDent = 'NOLIGTABLE')
                     then FlLigTableGlb:=false
                else if (IDent = 'LIGTABLE')
                     then FlLigTableGlb:=true
                else if (IDent = 'NEWDISCARD')
                     then FlDiscIncludeGlb:=true
                else if (IDent = 'NONEWDISCARD')
                     then FlDiscIncludeGlb:=false
                else if IDent = 'SCREEN'
                     then FlScreen:=true
                else if IDent = 'NOSCREEN'
                     then FlScreen:=false
                else if IDent = 'AUTOTFMWIDTH' then
                begin
                     FlFontAutoWidthGlb:=true;
                end
                else if IDent = 'NOAUTOTFMWIDTH' then
                begin
                     FlFontAutoWidthGlb:=false;
                end
                else if IDent = 'AUTOTFMCHAR' then
                begin
                     IndexTFMFontGlb:=ConvFromByte(sbuf,true);
                     FlFontTFMDataGlb:=2;
                end
                else if IDent = 'AUTOTFMMAPCHAR' then
                begin
                     IndexTFMFontGlb:=ConvFromByte(sbuf,true);
                     FlFontTFMDataGlb:=1;
                end
                else begin
                     ErrorLog('*** Error : Unknown parameter OPTIONS/'+IDent+' is ignored');
                     LogReadState; FlagError:=true;
                end;
           end;
           end; {case}
     end; {while}
     {--------- end OPTION --------------------}
end; {LOption}


{-------------------------------------------------}
{                                                 }
{   This procedure processes operator OUTPUT      }
{                                                 }
{-------------------------------------------------}
procedure LOutput(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
begin
     RState:=RS;
     {--------- OUTPUT --------------------}
     if NBuf > 0 then
     begin
         if FontNameGlb <> '' then
         begin
             ErrorLog('*** Warning : OUTPUT font name is redefined');
             LogReadState;
         end;
         sbuf:=PackBuf(NBuf,Buf);
         FontNameGlb:=ConvFromString(sbuf,true);
     end;

     if RState = OpenBrace then icn:=1
                           else icn:=0;
     while (icn > 0) do
     begin
           RState:=NoCommRead(IDent,NBuf,Buf);
           case RState of
           OpenBrace : begin
                icn:=icn+1;
                ErrorLog('*** Error : OPTIONS cannot have list sub-parameters');
                ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
                LogReadState; FlagError:=true;
           end;
           CloseLex   : begin
                icn:=icn-1;
           end;
           EndFile    : begin
                ErrorLog('*** Error : Unfinished operator (end-of-file)');
                icn:=0; FlagError:=true;
           end;
           CloseBrace : if icn = 1 then
           begin
                if (NBuf > 0) then
                begin
                     ErrorLog('*** Warning : OUTPUT ('+IDent+': string parameter is ignored');
                     LogReadState;
                end;
                if IDent = 'ALLCHAR'
                     then FlOutChar:=0
                else if IDent = 'ALPHA'
                     then FlOutChar:=1
                else if IDent = 'ALPHANUM'
                     then FlOutChar:=2
                else if IDent = 'ALLCODE'
                     then FlOutChar:=3
                else if (IDent = 'DEC') or (IDent = 'DECIMAL')
                     then FlOutByte:=0
                else if (IDent = 'OCT') or (IDent = 'OCTAL')
                     then FlOutByte:=1
                else if (IDent = 'HEX') or (IDent = 'HEXADECIMAL')
                     then FlOutByte:=2
                else begin
                     ErrorLog('*** Error : Unknown parameter OUTPUT/'+IDent+' is ignored');
                     LogReadState; FlagError:=true;
                end;
           end;
           end; {case}
     end; {while}
     {--------- end OUTPUT --------------------}
end; {LOutput}


{-------------------------------------------------}
{                                                 }
{   This procedure processes operator SAVETABLE   }
{                                                 }
{-------------------------------------------------}
procedure LSave(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
begin
     RState:=RS;
     {--------- SAVETABLE --------------------}
     if NBuf <= 0 then
     begin
           ErrorLog('*** Warning : SAVETABLE without string parameter');
           LogReadState; FlagError:=true;
     end
     else begin
          if SaveTableName <> '' then
          begin
               ErrorLog('*** Warning : SAVETABLE file name is redefined');
               LogReadState;
          end;
          sbuf:=PackBuf(NBuf,Buf);
          SaveTableName:=ConvFromString(sbuf,true);
     end;

     if RState = OpenBrace then icn:=1
                           else icn:=0;

     while (icn > 0) do
     begin
          RState:=NoCommRead(IDent,NBuf,Buf);
          case RState of
          OpenBrace : begin
              icn:=icn+1;
              ErrorLog('*** Error : SAVETABLE cannot have list sub-parameters');
              ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
              LogReadState; FlagError:=true;
          end;
          CloseBrace : begin
              if icn = 1 then
              begin
                  if NBuf > 0 then
                  begin
                       ErrorLog('*** Warning : SAVETABLE/'+IDent+' : sub-list is ignored');
                       LogReadState;
                  end;
                  if IDent = 'FULL' then
                  begin
                       FlagSaveUnknown:=true;
                  end
                  else if IDent = 'SHORT' then
                  begin
                       FlagSaveUnknown:=false;
                  end
                  else begin
                       ErrorLog('*** Error : Unknown parameter SAVETABLE/'+IDent+' is ignored');
                       LogReadState; FlagError:=true;
                  end;
              end;
          end;
          CloseLex   : begin
              icn:=icn-1;
          end;
          EndFile    : begin
              ErrorLog('*** Error : Unfinished operator (end-of-file)');
              icn:=0; FlagError:=true;
          end;
          end; {case}
     end; {while}
     {--------- end SAVETABLE --------------------}
end; {LSave}

{-------------------------------------------------}
{                                                 }
{   This procedure processes operator MAPFONT     }
{                                                 }
{-------------------------------------------------}
procedure LMapFontErr(IDent,sbuf : string);
begin
    if (sbuf <> '') and (sbuf <> ' ') then
    begin
         ErrorLog('*** Warning : MAPFONT/'+IDent+': string parameter is ignored');
         LogReadState;
    end;
end; {LMapFontErr}
procedure LMapfont(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
var ichar  : longint;
begin
     RState:=RS;
     {--------- MAPFONT --------------------}
     if NBuf <= 0 then
     begin
           ErrorLog('*** Error : MAPFONT without index parameter');
           LogReadState; FlagError:=true;
     end;
     sbuf:=PackBuf(NBuf,Buf);
     ichar:=ConvFromLongInt(sbuf,true);

     if RState = OpenBrace then
     begin
          icn:=1;
          if (ichar > MaxFontNumber) or (ichar < 0) then
          begin
               ErrorLog('*** Error : MAPFONT index = '+ConvInt(ichar)+' is illegal.');
               LogReadState;
               SkipOp(RState,Buf);
               FlagError:=true; FlagSevere:=true;
               icn:=0;
          end
          else if FontsParm^[ichar].FlagFontUsed then
          begin
               ErrorLog('*** Warning : MAPFONT D '+ConvInt(ichar)+' has been used already.');
               LogReadState;
          end
          else begin
               FontsParm^[ichar].FlagFontUsed:=true;
          end;
     end
     else begin
          icn:=0;
          ErrorLog('*** Warning : MAPFONT without list parameters is ignored');
          LogReadState;
     end;

     while (icn > 0) do
     begin
          RState:=NoCommRead(IDent,NBuf,Buf);
          case RState of
          OpenBrace : if IDent = 'INCLUDECHAR' then
          begin
                   LIncludeChar(NBuf, Buf, RState,
                             FontsParm^[ichar].FlInclude,
                             FontsParm^[ichar].DefInclude,
                             FontsParm^[ichar].FlNoNextChar,
                             FontsParm^[ichar].DefNoNextChar);
           end
           else begin
                ErrorLog('*** Error : Unknown parameter MAPFONT/'+IDent+' is ignored');
                LogReadState; FlagError:=true;
                SkipOp(RState,Buf);
           end;
           CloseLex   : begin
                icn:=icn-1;
           end;
           EndFile    : begin
                ErrorLog('*** Error : Unfinished operator (end-of-file)');
                icn:=0; FlagError:=true;
           end;
           CloseBrace : if icn = 1 then
           begin
               if (NBuf > 0) then
               begin
                    sbuf:=PackBuf(NBuf,Buf);
               end
               else sbuf:='';

               if IDent = 'CHECKSUM' then
               begin
                    if FontsParm^[ichar].FlagCheckSum then
                    begin
                          ErrorLog('*** Warning : CHECKSUM for font '+ConvInt(ichar)+' is redefined.');
                          LogReadState;
                    end;
                    FontsParm^[ichar].CheckSum:=ConvFromLongInt(sbuf,true);
                    FontsParm^[ichar].FlagCheckSum:=true;
               end
               else if IDent = 'TRACE' then
               begin
                    if (sbuf = '') or (sbuf = ' ') then
                    begin
                        FontsParm^[ichar].FlTraceLig:=2;
                        FontsParm^[ichar].DefTraceLig:=true;
                    end
                    else begin
                        FontsParm^[ichar].FlTraceLig:=ConvFromByte(sbuf,true);
                        if not (FontsParm^[ichar].FlTraceLig in [0,1,2,3])
                            then FontsParm^[ichar].FlTraceLig:=3;
                        FontsParm^[ichar].DefTraceLig:=true;
                    end;
               end
               else if IDent = 'NOTRACE' then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].FlTraceLig:=0;
                    FontsParm^[ichar].DefTraceLig:=true;
               end
               else if IDent = 'AUTOTFMWIDTH' then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].FlFontAutoWidth:=true;
                    FontsParm^[ichar].DefFontAutoWidth:=true;
               end
               else if IDent = 'NOAUTOTFMWIDTH' then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].FlFontAutoWidth:=false;
                    FontsParm^[ichar].DefFontAutoWidth:=true;
               end
               else if IDent = 'AUTOTFMCHAR' then
               begin
                    FontsParm^[ichar].IndexTFMFont:=ConvFromByte(sbuf,true);
                    FontsParm^[ichar].FlFontTFMData:=2;
               end
               else if IDent = 'AUTOTFMMAPCHAR' then
               begin
                    FontsParm^[ichar].IndexTFMFont:=ConvFromByte(sbuf,true);
                    FontsParm^[ichar].FlFontTFMData:=1;
               end
               else if IDent = 'PHANTOM' then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].FlagNullDvi:=true;
                    FontsParm^[ichar].DefNullDvi:=true;
               end
               else if IDent = 'NOPHANTOM' then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].FlagNullDvi:=false;
                    FontsParm^[ichar].DefNullDvi:=true;
               end
               else if (IDent = 'NAME') or (IDent = 'FONTNAME')
               then begin
                    if FontsParm^[ichar].Fontname <> '' then
                    begin
                          ErrorLog('*** Warning : FONTNAME for font '+ConvInt(ichar)+' is redefined.');
                          LogReadState;
                    end;
                    FontsParm^[ichar].Fontname:=ConvFromString(sbuf,true);
               end
               else if (IDent = 'TFMINPUT') then
               begin
                    if FontsParm^[ichar].FontTFMName <> '' then
                    begin
                          ErrorLog('*** Warning : TFMINPUT for font '+ConvInt(ichar)+' is redefined.');
                          LogReadState;
                    end;
                    FontsParm^[ichar].FontTFMName:=ConvFromString(sbuf,true);
               end
               else if (IDent = 'FONTAREA') then
               begin
                    if FontsParm^[ichar].Fontarea <> '' then
                    begin
                          ErrorLog('*** Warning : FONTAREA for font '+ConvInt(ichar)+' is redefined.');
                          LogReadState;
                    end;
                    FontsParm^[ichar].Fontarea:=ConvFromString(sbuf,true);
               end
               else if (IDent = 'FONTAT') then
               begin
                    FontsParm^[ichar].FontAT:=ConvFromReal(sbuf,true);
                    FontsParm^[ichar].FlFontAT:=true;
               end
               else if (IDent = 'NOLIGTABLE') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].FlLigTable:=false;
                    FontsParm^[ichar].DefLigTable:=true;
               end
               else if (IDent = 'LIGTABLE') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].FlLigTable:=true;
                    FontsParm^[ichar].DefLigTable:=true;
               end
               else if (IDent = 'NEWDISCARD') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].FlDiscIncl:=true;
                    FontsParm^[ichar].DefDiscIncl:=true;
               end
               else if (IDent = 'NONEWDISCARD') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].FlDiscIncl:=false;
                    FontsParm^[ichar].DefDiscIncl:=true;
               end
               else if (IDent = 'FULL') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].MapFontMode:=FModeFull;
               end
               else if (IDent = '7TO8') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].MapFontMode:=FMode7to8;
               end
               else if (IDent = '8TO7') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].MapFontMode:=FMode8to7;
               end
               else if (IDent = '7TO7') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].MapFontMode:=FModeLBIT;
               end
               else if (IDent = '8TO8') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].MapFontMode:=FModeHBIT;
               end
               else if (IDent = 'JWNCYR') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].MapFontMode:=FModeJWNCYR;
               end
               else if (IDent = 'CYRTUG') then
               begin
                    LMapFontErr(IDent, sbuf);
                    FontsParm^[ichar].MapFontMode:=FModeAltGost;
               end
               else begin
                    ErrorLog('*** Error : Unknown parameter MAPFONT/'+IDent+' is ignored');
                    LogReadState; FlagError:=true;
               end;
           end;
           end; {case}
     end; {while}
     {--------- end MAPFONT ----------------}
end; {LMapFont}


{-------------------------------------------------}
{                                                 }
{   This procedure processes operator DISCARD     }
{                                                 }
{-------------------------------------------------}
procedure LDiscardOne(ichar, cfontd : integer);
var ptrD   : ptrDiscardChar;
    fl     : boolean;
begin
     ptrD:=ptrDiscCharGlb; fl:=false;
     while (ptrD <> nil) and (not fl) do
     begin
           fl:=(ptrD^.charnum = ichar)
               and (ptrD^.fontnum = cfontd);
           ptrD:=ptrD^.ptrNext;
     end;

     if fl then
     begin
          ErrorLog('*** Warning : DISCARD char '
                        +ConvChar(ichar)+' in font D '+ConvByte(cfontd)
                        +' was specified already');
          LogReadState;
     end
     else begin
          new(ptrD);
          with ptrD^ do
          begin
               ptrNext:=ptrDiscCharGlb;
               charnum:=ichar;
               fontnum:=cfontd;
          end;
          ptrDiscCharGlb:=ptrD;
     end;
end; {LDiscardOne}
procedure LDiscard(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
    ichar  : integer;
    ii, ichar2 : integer;
    cfontd : integer;
begin
     RState:=RS;
     {--------- DISCARD --------------------}
     if NBuf > 0 then
     begin
          ErrorLog('*** Error : DISCARD cannot have string parameter');
          ErrorLog('***         String parameter is ignored');
          LogReadState; FlagError:=true;
     end;

     cfontd:=0;

     if RState = OpenBrace then icn:=1
                           else icn:=0;
     while (icn > 0) do
     begin
         RState:=NoCommRead(IDent,NBuf,Buf);
         case RState of
         OpenBrace  : begin
                icn:=icn+1;
                ErrorLog('*** Error : DISCARD cannot have parameters');
                ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
                LogReadState; FlagError:=true;
         end;
         CloseLex   : begin
               icn:=icn-1;
         end;
         EndFile    : begin
               ErrorLog('*** Error : Unfinished operator (end-of-file)');
               icn:=0; FlagError:=true;
         end;
         CloseBrace : if icn = 1 then
         begin
                if (IDENT = 'FONT') then
                begin
                     sbuf:=PackBuf(NBuf,Buf);
                     cfontd:=ConvFromByte(sbuf,true);
                end
                else if (IDent = 'CHAR') then
                begin
                     sbuf:=PackBuf(NBuf,Buf);
                     ichar:=ConvFromByte(sbuf,true);
                     LDiscardOne(ichar,cfontd);
                end
                else if (IDent = 'RANGE') then
                begin
                     sbuf:=PackBuf(NBuf,Buf);
                     ichar:=ConvFromByte(sbuf,false);
                     ichar2:=ConvFromByte(sbuf,true);
                     for ii:=ichar to ichar2 do
                     begin
                          LDiscardOne(ii,cfontd);
                     end;
                end
                else begin
                     ErrorLog('*** Error : Unknown DISCARD sub-operator is ignored :'+Ident);
                     LogReadState; FlagError:=true;
                end;
         end;
         end; {case}
     end; {while}
     {--------- end DISCARD ----------------}
end; {LDiscard}


{-------------------------------------------------}
{                                                 }
{   This procedure processes operator NOAUTOADD   }
{                                                 }
{-------------------------------------------------}
procedure LNoAutoAddOneChar(ichar : integer);
begin
     if (ichar >= 0) and (ichar <= 255) then
     begin
          case CharDataGlb^[ichar].marked of
          CharNotUsed : CharDataGlb^[ichar].marked:=CharDiscard;
          CharUsed, CharDVI : begin
                ErrorLog('*** Warning : NOAUTOADDCHAR char '
                           +ConvChar(ichar)+' is already used as active');
                LogReadState;
          end;
          CharDiscard : begin
                ErrorLog('*** Warning : NOAUTOADDCHAR char '
                           +ConvChar(ichar)+' was specified already');
                LogReadState;
          end;
          end; {case}
     end
     else begin
          ErrorLog('*** Warning : NOAUTOADDCHAR char code is < 0 or > 255 : '
                           +ConvChar(ichar));
          LogReadState;
     end;
end; {LNoAutoAddOneChar}
procedure LNoAutoAdd(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
    ichar  : integer;
    ii, ichar2 : integer;
begin
     RState:=RS;
     {--------- NOAUTOADD --------------------}
     if NBuf > 0 then
     begin
          ErrorLog('*** Error : NOAUTOADDCHAR cannot have string parameter');
          ErrorLog('***         String parameter is ignored');
          LogReadState; FlagError:=true;
     end;

     if RState = OpenBrace then icn:=1
                           else icn:=0;
     while (icn > 0) do
     begin
         RState:=NoCommRead(IDent,NBuf,Buf);
         case RState of
         OpenBrace  : begin
                icn:=icn+1;
                ErrorLog('*** Error : NOAUTOADD cannot have parameters');
                ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
                LogReadState; FlagError:=true;
         end;
         CloseLex   : begin
               icn:=icn-1;
         end;
         EndFile    : begin
               ErrorLog('*** Error : Unfinished operator (end-of-file)');
               icn:=0; FlagError:=true;
         end;
         CloseBrace : if icn = 1 then
         begin
                if (IDent = 'CHAR')
                then begin
                     sbuf:=PackBuf(NBuf,Buf);
                     ichar:=ConvFromByte(sbuf,true);
                     LNoAutoAddOneChar(ichar);
                end
                else if (IDent = 'RANGE')
                then begin
                     sbuf:=PackBuf(NBuf,Buf);
                     ichar:=ConvFromByte(sbuf,false);
                     ichar2:=ConvFromByte(sbuf,true);
                     for ii:=ichar to ichar2 do
                     begin
                          LNoAutoAddOneChar(ii);
                     end;
                end
                else begin
                     ErrorLog('*** Error : Unknown NOAUTOADDCHAR sub-operator is ignored :'+Ident);
                     LogReadState; FlagError:=true;
                end;
         end;
         end; {case}
     end; {while}
     {--------- end NOAUTOADD ----------------}
end; {LNoAutoAdd}


procedure FreeDVIList(ichar : integer; chmark : CharMark);
var pDD, pDH : ptrDVIRecord;
    ss : string;
begin
     with CharDataGlb^[ichar] do
     begin
          if marked = CharDVI then
          begin
               pDD:=ptrDVI;
               while pDD <> nil do
               begin
                    pDH:=pDD;
                    pDD:=pDD^.ptrNext;
                    dispose(pDH);
               end;
               ptrDVI:=nil;
          end;
          marked:=chmark;



          if (chmark = CharDVI) or
             ((chmark <> marked) and (marked <> CharNotUsed))
          then begin
               case chmark of
               CharUsed    : ss:='MAP commands';
               CharDVI     : ss:='SETDVI';
               CharDiscard : ss:='DISCARD';
               CharNotUsed : ss:='UNKNOWN';
               else          ss:= '<unknown>';
               end; {case}
               ErrorLog('*** Warning : '+ss+' overwrites Character Status defined previously');
               LogReadState;
          end;

          if chmark in [CharUsed, CharDVI, CharDiscard, CharNotUsed] then
          begin
               marked:=CharUsed;
          end
          else begin
               ErrorLog('*** Error : internal error in FreeDVIList');
               LogReadState;
          end;

     end; {with}
end; {FreeDVIList}


{-------------------------------------------------------}
{                                                       }
{   This procedure processes operator CHARACTER/DVI     }
{                                                       }
{-------------------------------------------------------}
procedure LCharDVI(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState; ichar, cfontm, cfontz : integer);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
var pDD, pDH : ptrDVIRecord;
    s, sh    : string;
    i, j     : integer;
    fl, flf  : boolean;
begin
     RState:=RS;
     {--------- CHAR/DVI --------------------}
     FreeDVIList(ichar,CharDVI);

     CharDataGlb^[ichar].ptrDVI:=nil; pDD:=nil;

     if NBuf > 0 then
     begin
         ErrorLog('*** Error : CHARACTER/DVI cannot have string parameter');
         ErrorLog('***         String parameter is ignored');
         LogReadState; FlagError:=true;
     end;

     if RState = OpenBrace then icn:=1
     else begin
          icn:=0;
          ErrorLog('*** Warning : CHARACTER/SETDVI without list parameters');
          LogReadState;
     end;

     flf:=false;

     while (icn > 0) do
     begin
          RState:=NoCommRead(IDent,NBuf,Buf);
          pDH:=nil;

          case RState of
          OpenBrace  : begin
                icn:=icn+1;
                ErrorLog('*** Error : CHARACTER/DVI cannot have list parameters');
                ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
                LogReadState; FlagError:=true;
          end;
          CloseLex   : begin
                icn:=icn-1;
          end;
          EndFile    : begin
                ErrorLog('*** Error : Unfinished operator (end-of-file)');
                icn:=0; FlagError:=true;
          end;
          CloseBrace : if icn = 1 then
          begin
               if (IDent = 'FONT') or (IDent = 'SELECTFONT') then
               begin
                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVIFont;
                         sbuf:=PackBuf(NBuf,Buf);
                         nfont:=ConvFromByte(sbuf,true);
                         cfontm:=nfont;
                         flf:=true;
                    end;
               end
               else if (IDent = 'CHAR') or (IDent = 'SETCHAR') then
               begin
                    if not flf then
                    begin
                         ErrorLog('*** Warning : SELECTFONT D '+ConvInt(cfontm)
                                  +' is assumed before first SETCHAR from DVI list');
                         LogReadState;
                         new(pDH);
                         with pDH^ do
                         begin
                              TDVI:=DVIFont; nfont:=cfontm;
                         end;
                         if pDD <> nil then pDD^.ptrNext:=pDH
                                       else CharDataGlb^[ichar].ptrDVI:=pDH;
                         pDD:=pDH;
                         pDD^.ptrNext:=nil;
                         pDD^.Dummy:=0;
                         flf:=true;
                    end;

                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVIChar;
                         sbuf:=PackBuf(NBuf,Buf);
                         nchar:=ConvFromByte(sbuf,true);
                         cwidth:=0.0; cheight:=0.0; cdepth:=0.0;
                    end;
               end
               else if (IDent = 'RULE') or (IDent = 'SETRULE') then
               begin
                    sbuf:=DelSpaces(PackBuf(NBuf,Buf));
                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVIRule;
                         height:=ConvFromReal(sbuf,false);
                         width:=ConvFromReal(sbuf,true);
                    end;
               end
               else if (IDent = 'RIGHT') or (IDent = 'MOVERIGHT') then
               begin
                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVIRight;
                         sbuf:=PackBuf(NBuf,Buf);
                         dist:=ConvFromReal(sbuf,true);
                    end;
               end
               else if (IDent = 'LEFT') or (IDent = 'MOVELEFT') then
               begin
                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVILeft;
                         sbuf:=PackBuf(NBuf,Buf);
                         dist:=ConvFromReal(sbuf,true);
                    end;
               end
               else if (IDent = 'UP') or (IDent = 'MOVEUP') then
               begin
                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVIUp;
                         sbuf:=PackBuf(NBuf,Buf);
                         dist:=ConvFromReal(sbuf,true);
                    end;
               end
               else if (IDent = 'DOWN')  or (IDent = 'MOVEDOWN') then
               begin
                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVIDown;
                         sbuf:=PackBuf(NBuf,Buf);
                         dist:=ConvFromReal(sbuf,true);
                    end;
               end
               else if IDent = 'PUSH' then
               begin
                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVIPush;
                         if NBuf > 0 then
                         begin
                              ErrorLog('*** Warning : Rest of operator CHARACTER/DVI/PUSH is ignored :');
                              ErrorLog('           "'+PackBuf(NBuf,Buf)+'"');
                              LogReadState; FlagError:=true;
                         end;
                    end;
               end
               else if IDent = 'POP' then
               begin
                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVIPop;
                         if NBuf > 0 then
                         begin
                              ErrorLog('*** Warning : Rest of operator CHARACTER/DVI/POP is ignored :');
                              ErrorLog('           "'+PackBuf(NBuf,Buf)+'"');
                              LogReadState; FlagError:=true;
                         end;
                    end;
               end
               else if (IDent = 'SPECIAL') then
               begin
                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVISpec;
                         s:=PackBuf(NBuf,Buf);
                         sh:='';
                         while (s <> '') and (s <> '') do
                         begin
                              sh:=sh+' '+ConvFromString(s,false);
                         end;
                         spec:=s;
                    end;
               end
               else if (IDent = 'SPECIALHEX') or (IDent = 'HEX') then
               begin
                    s:=PackBuf(NBuf,Buf);
                    s:=ConvFromString(s,true);
                    s:=DelSpaces(s);
                    s:=UpCaseString(s);

                    i:=ord(s[0]);
                    for j:=1 to i do
                    if not (s[j] in ['0','1','2','3','4','5','6','7',
                                     '8','9','A','B','C','D','E','F'])
                    then begin
                         ErrorLog('*** Error : String "'+s+'" contains not-hex characters ['+s[j]+']');
                         LogReadState;
                         s[j]:='0';
                    end;
                    if (i and 1) <> 0 then
                    begin
                         ErrorLog('*** Error : String "'+s+'" contains non-even number of hex characters');
                         LogReadState;
                         s[0]:=chr(i-1);
                    end;

                    new(pDH);
                    with pDH^ do
                    begin
                         TDVI:=DVISpecHex;
                         spec:=s;
                    end;
               end
               else begin
                    ErrorLog('*** Error : Unknown CHARACTER/DVI sub-operator is ignored :'+Ident);
                    LogReadState; FlagError:=true;
                    SkipOp(RState,Buf);
                end;
          end;
          end; {case}

          if pDH <> nil then
          begin
               if pDD <> nil then pDD^.ptrNext:=pDH
                             else CharDataGlb^[ichar].ptrDVI:=pDH;
               pDD:=pDH;
               pDD^.ptrNext:=nil;
               pDD^.Dummy:=0;
          end; {if}

     end; {while icn > 0}

     {--------- end CHAR/DVI ----------------}

end; {LCharDVI}


{-------------------------------------------------------}
{                                                       }
{   This procedure processes operator CHARACTER/VARCHAR }
{                                                       }
{-------------------------------------------------------}
procedure LVarChar(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState; ichar : integer);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
begin
     RState:=RS;
     {--------- CHAR/VARCHAR --------------------}
     if CharDataGlb^[ichar].FlAddParm in [0,2,3] then
     begin
          if CharDataGlb^[ichar].FlAddParm = 0
             then CharDataGlb^[ichar].FlAddParm:=2;
          CharDataGlb^[ichar].FlVarChar:=true;
          if NBuf > 0 then
          begin
               ErrorLog('*** Error : CHARACTER/VARCHAR with string parameter');
               LogReadState; FlagError:=true;
          end;

          if RState = OpenBrace then icn:=1
          else begin
               icn:=0;
               ErrorLog('*** Warning : CHARACTER/VARCHAR without list parameters');
               LogReadState;
          end;

          while (icn > 0) do
          begin
               RState:=NoCommRead(IDent,NBuf,Buf);
               case RState of
               OpenBrace : begin
                         icn:=icn+1;
                         ErrorLog('*** Error : CHARACTER/VARCHAR cannot have list parameters');
                         ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored.');
                         LogReadState; FlagError:=true;
               end;
               CloseLex   : begin
                   icn:=icn-1;
               end;
               EndFile    : begin
                   ErrorLog('*** Error : Unfinished operator (end-of-file)');
                   icn:=0; FlagError:=true;
               end;
               CloseBrace : if icn = 1 then
               begin
                    if IDent = 'TOP' then
                    begin
                         if RState <> CloseBrace
                            then FileFix11('VARCHAR/'+IDent);
                         sbuf:=PackBuf(NBuf,Buf);
                         CharDataGlb^[ichar].Top:=ConvFromByte(sbuf,true);
                         CharDataGlb^[ichar].FlTop:=true;
                    end
                    else if IDent = 'MID' then
                    begin
                         if RState <> CloseBrace
                            then FileFix11('VARCHAR/'+IDent);
                         sbuf:=PackBuf(NBuf,Buf);
                         CharDataGlb^[ichar].Mid:=ConvFromByte(sbuf,true);
                         CharDataGlb^[ichar].FlMid:=true;
                    end
                    else if IDent = 'BOT' then
                    begin
                         if RState <> CloseBrace
                            then FileFix11('VARCHAR/'+IDent);
                         sbuf:=PackBuf(NBuf,Buf);
                         CharDataGlb^[ichar].Bot:=ConvFromByte(sbuf,true);
                         CharDataGlb^[ichar].FlBot:=true;
                    end
                    else if IDent = 'REP' then
                    begin
                         if RState <> CloseBrace
                            then FileFix11('VARCHAR/'+IDent);
                         sbuf:=PackBuf(NBuf,Buf);
                         CharDataGlb^[ichar].Rep:=ConvFromByte(sbuf,true);
                         CharDataGlb^[ichar].FlRep:=true;
                         CharDataGlb^[ichar].FlAddParm:=3;
                    end
                    else begin
                         ErrorLog('*** Error : Unknown VARCHAR sub-operator is ignored :'+Ident);
                         LogReadState; FlagError:=true;
                    end;
               end;
               end; {case}
          end; {while}
     end {if}
     else begin
          ErrorLog('*** Error : VARCHAR conflicts with NEXTLARGER (defined earlier).');
          ErrorLog('            Operator VARCHAR is ignored.');
          LogReadState;
          SkipOp(RState,Buf);
          FlagError:=true;
     end;
     {--------- end CHAR/VARCHAR ----------------}

end; {LVarChar}

{-------------------------------------------------}
{                                                 }
{   This procedure processes operator CHARACTER   }
{                                                 }
{-------------------------------------------------}
procedure LCharacter(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState);
var RState   : ReadState;
    icn      : integer;
    IDent,
    sbuf     : string;
const cfontm : integer = 0;
const cfontz : integer = 0;
var ichar    : integer;
    ihlp     : integer;
var pDD, pDH : ptrDVIRecord;
begin
     RState:=RS;

     cfontz:=GlbSizeFont; cfontm:=GlbMapFont;

     with CharDataGlb^[ichar] do
     begin
          if not DefMapchar  then mapchar:=ichar;
          if not DefMapfont  then mapfont:=cfontm;
          if not DefSizechar then sizechar:=ichar;
          if not DefSizefont then sizefont:=cfontz;
     end; {with}

     {--------- CHARACTER --------------------}
     if NBuf <= 0 then
     begin
          ErrorLog('*** Error : CHARACTER without parameter');
          LogReadState; FlagError:=true;
     end;
     sbuf:=PackBuf(NBuf,Buf);
     ichar:=ConvFromByte(sbuf,true);

     if RState = OpenBrace then icn:=1
     else begin
          icn:=0;
          ErrorLog('*** Warning : CHARACTER without list parameters is ignored');
          LogReadState;
     end;

     while (icn > 0) do
     begin
        RState:=NoCommRead(IDent,NBuf,Buf);
        case RState of
        OpenBrace : begin
            icn:=icn+1;
            if (icn <> 2) then
            begin
                 ErrorLog('*** Error : CHARACTER cannot have list parameters');
                 ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
                 LogReadState; FlagError:=true;
            end
            else begin
                 if (IDent = 'DVI') or (IDent = 'SETDVI') then
                 begin
                      LCharDVI(NBuf, Buf, RState, ichar, cfontm, cfontz);
                 end
                 else if (IDent = 'VARCHAR') then
                 begin
                      LVarChar(NBuf, Buf, RState, ichar);
                 end
                 else begin
                      ErrorLog('*** Error : CHARACTER cannot have list parameters with sub-lists');
                      ErrorLog('            except SETDVI and VARCHAR. Parameter '+IDent+' is ignored.');
                      LogReadState; FlagError:=true;
                 end;
            end;
        end;
        CloseLex : begin
            icn:=icn-1;
        end;
        EndFile  : begin
            ErrorLog('*** Error : Unfinished operator (end-of-file)');
            icn:=0; FlagError:=true;
        end;
        CloseBrace : if icn = 1 then
        begin
            if (IDent = 'DVI') or (IDent = 'SETDVI') then
            begin
                 LCharDVI(NBuf, Buf, RState, ichar, cfontm, cfontz);
            end
            else if (IDent = 'VARCHAR') then
            begin
                 LVarChar(NBuf, Buf, RState, ichar);
            end
            else if (IDent = 'TFMFONT')
            then begin
                sbuf:=PackBuf(NBuf,Buf);
                with CharDataGlb^[ichar] do
                begin
                     sizefont:=ConvFromByte(sbuf,true);
                     if DefSizeFont or (DefFlTFMData and (not FlTFMData))
                     then begin
                          ErrorLog('*** Warning : CHARACTER/(TFMFONT,NOTFMDATA) is redefined.');
                     end;
                     DefFlTFMData:=true; FlTFMData:=true; DefSizeFont:=true;
                end;
            end
            else if (IDent = 'TFMCHAR')
            then begin
                sbuf:=PackBuf(NBuf,Buf);
                with CharDataGlb^[ichar] do
                begin
                     sizechar:=ConvFromByte(sbuf,true);
                     if DefSizeChar or (DefFlTFMData and (not FlTFMData))
                     then begin
                          ErrorLog('*** Warning : CHARACTER/(TFMCHAR,NOTFMDATA) is redefined.');
                     end;
                     DefFlTFMData:=true; FlTFMData:=true; DefSizeChar:=true;
                end;
            end
            else if (IDent = 'NOTFMDATA')
            then begin
                with CharDataGlb^[ichar] do
                begin
                     if DefFlTFMData and FlTFMData then
                     begin
                          ErrorLog('*** Warning : CHARACTER/(TFMCHAR,TFMFONT) is redefined.');
                     end;
                     DefFlTFMData:=true; FlTFMData:=false;
                     DefSizeFont:=false; DefSizeChar:=false;
                end;
            end
            else if (IDent = 'SELECTFONT') or (IDent = 'FONT')
            then begin
                FreeDVIList(ichar,CharUsed);
                sbuf:=PackBuf(NBuf,Buf);
                with CharDataGlb^[ichar] do
                begin
                     mapfont:=ConvFromByte(sbuf,true);
                     if DefMapFont then
                     begin
                         ErrorLog('*** Warning : SELECTFONT is redefined');
                         LogReadState;
                     end;
                     DefMapFont:=true;
                end;
            end
            else if (IDent = 'SETCHAR') or (IDent = 'CHAR') then
            begin
                 FreeDVIList(ichar,CharUsed);
                 sbuf:=PackBuf(NBuf,Buf);
                 with CharDataGlb^[ichar] do
                 begin
                      mapchar:=ConvFromByte(sbuf,true);
                      if DefMapChar then
                      begin
                           ErrorLog('*** Warning : SETCHAR is redefined');
                           LogReadState;
                      end;
                      DefMapChar:=true;
                 end;
            end
            else if IDent = 'DISCARD' then
            begin
                 FreeDVIList(ichar,CharDiscard);
            end
            else if IDent = 'UNKNOWN' then
            begin
                 FreeDVIList(ichar,CharNotUsed);
            end
            else if IDent = 'PHANTOM' then
            begin
                 CharDataGlb^[ichar].FlPhantom:=true;;
                 CharDataGlb^[ichar].DefFlPhantom:=true;;
            end
            else if IDent = 'NOPHANTOM' then
            begin
                 CharDataGlb^[ichar].FlPhantom:=false;
                 CharDataGlb^[ichar].DefFlPhantom:=true;;
            end
            else if IDent = 'AUTOTFMWIDTH' then
            begin
                with CharDataGlb^[ichar] do
                begin
                     if DefAutoWidth and (not FlAutoWidth) then
                     begin
                          ErrorLog('*** Warning : CHARACTER/NOAUTOTFMWIDTH is redefined.');
                     end;
                     DefAutoWidth:=true;
                     FlAutoWidth:=true;
                end;
            end
            else if IDent = 'NOAUTOTFMWIDTH' then
            begin
                with CharDataGlb^[ichar] do
                begin
                     if DefAutoWidth and FlAutoWidth then
                     begin
                          ErrorLog('*** Warning : CHARACTER/AUTOTFMWIDTH is redefined.');
                     end;
                     DefAutoWidth:=true;
                     FlAutoWidth:=false;
                end;
            end
            else if IDent = 'PKWIDTH' then
            begin
                sbuf:=PackBuf(NBuf,Buf);
                CharDataGlb^[ichar].PKWidth:=ConvFromReal(sbuf,true);
                CharDataGlb^[ichar].DefPKWidth:=true;
            end
            else if IDent = 'CHARWD' then
            begin
                 if RState <> CloseBrace
                    then FileFix11('CHARACTER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 CharDataGlb^[ichar].CharWD:=ConvFromReal(sbuf,true);
                 CharDataGlb^[ichar].FlCharWD:=true;
            end
            else if IDent = 'CHARHT' then
            begin
                 if RState <> CloseBrace
                    then FileFix11('CHARACTER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 CharDataGlb^[ichar].CharHT:=ConvFromReal(sbuf,true);
                 CharDataGlb^[ichar].FlCharHT:=true;
            end
            else if IDent = 'CHARDP' then
            begin
                 if RState <> CloseBrace
                    then FileFix11('CHARACTER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 CharDataGlb^[ichar].CharDP:=ConvFromReal(sbuf,true);
                 CharDataGlb^[ichar].FlCharDP:=true;
            end
            else if IDent = 'CHARIC' then
            begin
                 if RState <> CloseBrace
                    then FileFix11('CHARACTER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 CharDataGlb^[ichar].CharIC:=ConvFromReal(sbuf,true);
                 CharDataGlb^[ichar].FlCharIC:=true;
            end
            else if IDent = 'NEXTLARGER' then
            begin
                 if RState <> CloseBrace
                    then FileFix11('CHARACTER/'+IDent);
                 if CharDataGlb^[ichar].FlAddParm in [0,1] then
                 begin
                      sbuf:=PackBuf(NBuf,Buf);
                      CharDataGlb^[ichar].NextLarger:=ConvFromByte(sbuf,true);
                      CharDataGlb^[ichar].FlAddParm:=1;
                      CharDataGlb^[ichar].FlNextLarger:=true;
                 end
                 else begin
                      ErrorLog('*** Error : NEXTLARGER operator conflicts'
                                +' with the previously defined VARCHAR');
                      LogReadState; FlagError:=true;
                 end;
            end
            else begin
                 ErrorLog('*** Error : Unknown CHARACTER sub-operator is ignored :'+Ident);
                 LogReadState;
                 SkipOp(RState,Buf);
                 FlagError:=true;
             end;
        end;
        end; {case}
     end; {while}
     {--------- end CHARACTER ----------------}
end; {LCharacter}


{-------------------------------------------------}
{                                                 }
{   This procedure processes operator HEADER      }
{                                                 }
{-------------------------------------------------}
procedure LHeader(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
    ihlp   : integer;
    res    : float;
begin
     RState:=RS;
     {--------- HEADER --------------------}
     if NBuf > 0 then
     begin
          ErrorLog('*** Error : HEADER string parameter is ignored.');
          LogReadState; FlagError:=true;
     end;

     if RState = OpenBrace then icn:=1
     else begin
          icn:=0;
          ErrorLog('*** Warning : HEADER without list parameters is ignored');
          LogReadState;
     end;

     while (icn > 0) do
     begin
        RState:=NoCommRead(IDent,NBuf,Buf);
        case RState of
        OpenBrace : begin
            icn:=icn+1;
            if (icn <> 2) then
            begin
                 ErrorLog('*** Error : HEADER cannot have list parameters');
                 ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
                 LogReadState; FlagError:=true;
            end
            else begin
                 if (IDent = 'FONTDIMEN') then
                 begin
                      LoadFDimStruct(false, FontDimenGlb, HFlagsGlb,
			     RState, IDent, NBuf, Buf);
                      FlFontDimen:=true;
                 end
                 else begin
                      ErrorLog('*** Error : HEADER cannot have list parameters with sub-lists');
                      ErrorLog('            except FONTDIMEN. Parameter '+IDent+' is ignored.');
                      LogReadState; FlagError:=true;
                 end;
            end;
        end;
        CloseLex : begin
            icn:=icn-1;
        end;
        EndFile  : begin
            ErrorLog('*** Error : Unfinished operator (end-of-file)');
            icn:=0; FlagError:=true;
        end;
        CloseBrace : if icn = 1 then
        begin
	    if (IDent = 'FONT') then
	    begin
	    {--------- FONT INDEX --------------------}
                 if RState <> CloseBrace then FileFix11('HEADER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 ihlp:=ConvFromLongInt(sbuf,true);
                 if IndHeadGlb >= 0 then
                 begin
                      ErrorLog('*** MAPFONT '+ConvInt(IndHeadGlb)+' was specified already.');
                      ErrorLog('    MAPFONT '+ConvInt(ihlp)+' is used as the Header File now.');
                      LogReadState;
                 end;
                 if HeadNameGlb <> '' then
                 begin
                      ErrorLog('*** Header File was specified already ('
                                     +HeadNameGlb+').');
                      ErrorLog('    MAPFONT '+ConvInt(ihlp)+' is used as the Header File.');
                      LogReadState;
                      HeadNameGlb:='';
                 end;
		 IndHeadGlb:=ihlp;
	    {--------- end FONT INDEX ----------------}
	    end
	    else if (IDent = 'FILE') then
	    begin
	    {--------- HEADER FILE --------------------}
		 if RState <> CloseBrace then FileFix11('HEADER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 sbuf:=ConvFromString(sbuf,true);
                 if IndHeadGlb >= 0 then
                 begin
                      ErrorLog('*** MAPFONT '+ConvInt(IndHeadGlb)+' was specified.');
                      ErrorLog('    New Header File '+sbuf+' is used now.');
                      LogReadState;
                      IndHeadGlb:=-1;
                 end;
                 if HeadNameGlb <> '' then
                 begin
                      ErrorLog('*** Header File was specified already ('
                                     +HeadNameGlb+').');
                      ErrorLog('    New Header File '+sbuf+' is used.');
                      LogReadState;
                 end;
		 HeadNameGlb:=sbuf;
	    {--------- end HEADER FILE ----------------}
	    end
	    else if IDent = 'CHECKSUM' then
	    begin
	    {--------- CHECKSUM --------------------}
		 if RState <> CloseBrace then FileFix11('HEADER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
		 VParamGlb.FontCheckSum:=ConvFromLongInt(sbuf,true);
                 FlCheckSumGlb:=true;
	    {--------- end CHECKSUM --------------------}
	    end
	    else if IDent = 'DESIGNSIZE' then
	    begin
	    {--------- DESIGNSIZE --------------------}
		 if RState <> CloseBrace then FileFix11('HEADER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
		 res:=ConvFromReal(sbuf,true);
                 if res <= 0.0 then
                 begin
                      ErrorLog('*** Error : DESIGNSIZE <= 0.0');
                      LogReadState;
                      FlagError:=true;
                 end
                 else begin
		      VParamGlb.FontDesignSize:=res;
                      HFlagsGlb.FlFontDesignSize:=true;
                 end;
	    {--------- end DESIGNSIZE --------------------}
	    end
	    else if IDent = 'DESIGNUNITS' then
	    begin
	    {--------- DESIGNUNITS --------------------}
		 if RState <> CloseBrace then FileFix11('HEADER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
		 res:=ConvFromReal(sbuf,true);
                 if res <= 0.0 then
                 begin
                      ErrorLog('*** Error : DESIGNUNITS <= 0.0');
                      LogReadState;
                      FlagError:=true;
                 end
                 else begin
                      VParamGlb.FontDesignUnits:=res;
                      HFlagsGlb.FlFontDesignUnits:=true;
                 end;
	    {--------- end DESIGNUNITS --------------------}
	    end
	    else if IDent = 'CODINGSCHEME' then
	    begin
	    {--------- CODINGSCHEME --------------------}
		 if RState <> CloseBrace then FileFix11('HEADER/'+IDent);
                 sbuf:=GetFullString(NBuf,Buf,RState);
		 VParamGlb.FontCoding:=DelSpaces(sbuf);
		 HFlagsGlb.FlFontCoding:=true;
	    {--------- end CODINGSCHEME --------------------}
	    end
	    else if IDent = 'FAMILY' then
	    begin
	    {--------- FAMILY --------------------}
		 if RState <> CloseBrace then FileFix11('HEADER/'+IDent);
                 sbuf:=GetFullString(NBuf,Buf,RState);
		 VParamGlb.FontFamily:=DelSpaces(sbuf);
		 HFlagsGlb.FlFontFamily:=true;
	    {--------- end FAMILY --------------------}
	    end
	    else if IDent = 'FACE' then
	    begin
	    {--------- FACE --------------------}
		 if RState <> CloseBrace then FileFix11('HEADER/'+IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 VParamGlb.FontFace:=ConvFromByte(sbuf,true);
		 HFlagsGlb.FlFontFace:=true;
	    {--------- end FACE --------------------}
	    end
	    else if IDent = 'SEVENBITSAFEFLAG' then
	    begin
	    {--------- SEVENBITSAFEFLAG --------------------}
		 if RState <> CloseBrace then FileFix11('HEADER/'+IDent);
		 ErrorLog('*** Warning : SEVENBITSAFEFLAG is ignored');
		 LogReadState;
	    {--------- end SEVENBITSAFEFLAG --------------------}
	    end
	    else begin
                 ErrorLog('*** Error : Unknown HEADER sub-operator is ignored :'+Ident);
                 LogReadState;
                 SkipOp(RState,Buf);
                 FlagError:=true;
            end;
        end;
        end; {case}
     end; {while}
     {--------- end HEADER ----------------}
end; {LHeader}


{-------------------------------------------------}
{                                                 }
{   This is the main program to read              }
{   the table file (*.TBF) with user-defined      }
{   commands                                      }
{                                                 }
{-------------------------------------------------}
procedure LoadTableFile(ss : string);
var sh       : string;
    sbuf     : string;
    res      : float;
var FLigNew,
    FLigEnd  : ptrLigRecord;
var NBuf     : integer;
    Buf      : BufRecord;
    s, Ident : string;
    RState   : ReadState;
    icn      : integer;
    fl       : boolean;
begin

    sh:=FindFileLoc(ss,'.TBF');
    if sh = '' then
    begin
         ErrorLog('*** Unable to open file : '+ss);
         FlagError:=true; FlagSevere:=true;
         exit;
    end
    else begin
         ErrorLog('File '+sh+' is used to load MAP TABLE');
    end;

    StartRead(sh);

    while not EndOfRead do
    begin
         RState:=NoCommRead(IDent,NBuf,Buf);
         case RState of
         CloseLex : begin
            ErrorLog('*** Error : Illegal ")" is ignored');
            LogReadState; FlagError:=true;
         end;
         EndFile : if (Ident <> '') or (NBuf > 0) then
         begin
            ErrorLog('*** Error : Unfinished operator (end-of-file)');
            FlagError:=true;
         end;
         OpenBrace,
         CloseBrace : begin
            if IDent = 'OUTPUT' then
            begin
                LOutput(NBuf,Buf,RState);
            end
            else if (IDent = 'SAVETABLE') then
            begin
                LSave(NBuf,Buf,RState);
            end
            else if (IDent = 'OPTION') or (IDent = 'OPTIONS') then
            begin
                LOption(NBuf,Buf,RState);
            end
            else if (IDent = 'MAPFONT') or (IDent = 'FONT') then
            begin
                LMapFont(NBuf,Buf,RState);
            end
            else if (IDent = 'BOUNDARYCHAR') or (IDent = 'BCHAR') then
            begin
            {--------- BOUNDARYCHAR --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 BoundCharGlb:=ConvFromByte(sbuf,true);
            {--------- end BOUNDARYCHAR --------------------}
            end
            else if (IDent = 'TBFUNITS') then
            begin
            {--------- TBFUNITS --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 res:=ConvFromReal(sbuf,true);
                 if res <= 0.0 then
                 begin
                      ErrorLog('*** Error : TBFUNITS <= 0');
                      LogReadState;
                      FlagError:=true;
                 end
                 else LigDesignUnitsGlb:=res;
            {--------- end TBFUNITS --------------------}
            end
            else if (IDent = 'TBFSIZE') then
            begin
            {--------- TBFSIZE --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 res:=ConvFromReal(sbuf,true);
                 if res <= 0.0 then
                 begin
                      ErrorLog('*** Error : TBFSIZE <= 0');
                      LogReadState;
                      FlagError:=true;
                 end
                 else LigDesignSizeGlb:=res;
            {--------- end TBFSIZE ----------------}
            end
            else if (IDent = 'VTITLE') then
            begin
            {--------- TITLE --------------------}
                 VTitleGlb:=GetFullString(NBuf,Buf,RState);
            {--------- end TITLE ----------------}
            end
            else if (IDent = 'SETTFMFONT')
            then begin
            {--------- TFMFONT --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 GLBSizeFont:=ConvFromByte(sbuf,true);
            {--------- end TFMFONT --------------------}
            end
            else if (IDent = 'SETMAPFONT')
            then begin
            {--------- MAPFONT --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 GLBMapFont:=ConvFromByte(sbuf,true);
            {--------- end MAPFONT --------------------}
            end
            else if IDent = 'LIGTABLE' then
            begin
            {--------- LigTable ---------------------}
                 LoadLigStruct(FLigNew, FLigEnd,
			 RState, IDent, NBuf, Buf);
                if FLigNew <> nil then
                begin
                     CheckLig(FLigNew,UCharGlb);
                     if ptrLigTable <> nil then
                     begin
                        FLigEnd:=ptrLigTable;
                        while FLigEnd^.ptrNext <> nil
                           do FLigEnd:=FLigEnd^.ptrNext;
                        FLigEnd^.ptrNext:=FLigNew;
                     end
                     else ptrLigTable:=FLigNew;
                end;
            {-------- end LigTable ---------------------}
            end
            else if IDent = 'DISCARDCHAR' then
            begin
                LDiscard(NBuf,Buf,RState);
            end
            else if IDent = 'NOAUTOADDCHAR' then
            begin
                LNoAutoAdd(NBuf,Buf,RState);
            end
            else if IDent = 'HEADER' then
            begin
                LHeader(NBuf,Buf,RState);
            end
            else if (IDent = 'CHARACTER') or (IDent = 'CHAR') then
            begin
                LCharacter(NBuf,Buf,RState);
            end
            else begin
                 ErrorLog('*** Error : Unknown operator is ignored :'+Ident);
                 LogReadState; FlagError:=true;
                 SkipOp(RState,Buf);
            end;
         end; {CloseBrace, OpenBrace}
         end; {case}
    end; {while}
end; {LoadTableFile}

