            title   TeX_glue

; glue conversion subroutines for (e)TeX
; Copyright (C) 1992,96 by Peter Breitenlohner
; Distributed under terms of GNU General Public License

; In Turbo Pascal a 6-byte real is divided into three fields:
;           s (1 bit), f (39 bits), and e (8 bits)
; The value v of that number is
;           v=0                            if e=0
;           v=(-1)^s * 2^(e-129) * 1.f     if e<>0

; In PubliC TeX a 4-byte glue_ratio also has three fields:
;           s (1 bit), f (25 bits), and e (6 bits)
; The value v of that number is
;           v=0                            if e=0
;           v=(-1)^s * 2^(e-32) * 1.f      if e<>0
; this range suffices to represent non-zero values with
;           2^(-31)<|v|<2^(31)

adjust      equ     129-32       ; adjustment for exponents

CODE        segment word
            assume  cs:CODE

; function float(a:glue_ratio):real;
;           convert from glue_ratio to type real

            public float
float       proc   far
            push    bp
            mov     bp,sp

a_hi        equ     word ptr [bp+8]
a_lo        equ     word ptr [bp+6]

            mov     ax,a_lo
            mov     dx,a_hi      ; dx:ax = a
            or      al,al
            jz      float1       ; e=0
            mov     bx,0ffc0h
            and     bx,ax        ; dx:bx = (s,f,0)
            and     ax,3fh       ; ax = (0,e)
            add     al,adjust    ; adjust exponent
float1:     pop     bp
            ret     4
float       endp

; function unfloat(r:real):glue_ratio;
;           convert from real to type glue_ratio

            public unfloat
unfloat     proc   far
            push    bp
            mov     bp,sp

r_hi        equ     word ptr [bp+10]
r_md        equ     word ptr [bp+8]
r_lo        equ     word ptr [bp+6]

            mov     ax,r_lo
            mov     bx,r_md
            mov     dx,r_hi      ; dx:bx:ax = r
            or      al,al
            jz      unfloat2     ; e=0
            add     bx,20h       ; f + 2^(-18)
            jnc     unfloat1
            rol     dx,1         ; rotate sign to lowest bit
            add     dx,2         ; add carry from lower part of f
            adc     al,0         ; add carry to e (in this case f=0)
            ror     dx,1         ; rotate sign back to highest bit
unfloat1:   and     bl,0c0h      ; dx:bx = (s,f,0)
            sub     al,adjust    ; adjust exponent
            and     ax,3fh       ; ax = (0,e)
            or      ax,bx        ; dx:ax = (s,f,e)
unfloat2:   pop     bp
            ret     6
unfloat     endp

CODE        ends
            end
