// Java-Example.java
// 
// Included in the Alpha distribution as an example of the Java mode.
// 
// Source of original document:
// 
// http://www.npac.syr.edu/projects/tutorials/books/javanut/

// This example is from the book _Java in a Nutshell_ by David Flanagan.
// Written by David Flanagan.  Copyright (c) 1996-2000 O'Reilly & Associates.
// You may study, use, modify, and distribute this example for any purpose.
// This example is provided WITHOUT WARRANTY either expressed or implied.

import java.awt.*;

public class AllComponents extends Frame {
    MenuBar menubar;                // the menubar
    Menu file, help;                // menu panes
    Button okay, cancel;            // buttons
    List list;                      // A list of choices
    Choice choice;                  // A menu of choices
    CheckboxGroup checkbox_group;   // A group of button choices
    Checkbox[] checkboxes;          // the buttons to choose from
    TextField textfield;            // One line of text input
    TextArea  textarea;             // A text window
    ScrollableScribble scribble;    // An area to draw in.
    FileDialog file_dialog;
    
    Panel panel1, panel2 ;    // Sub-containers for all this stuff.
    Panel buttonpanel; 

    // The layout manager for each of the containers.
    GridBagLayout gridbag = new GridBagLayout();
    
    public AllComponents(String title) {
        super(title);
        
        // Create the menubar.  Tell the frame about it.
        menubar = new MenuBar();
        this.setMenuBar(menubar);
        // Create the file menu.  Add two items to it.  Add to menubar.
        file = new Menu("File");
        file.add(new MenuItem("Open"));
        file.add(new MenuItem("Quit"));
        menubar.add(file);
        // Create Help menu; add an item; add to menubar
        help = new Menu("Help");
        help.add(new MenuItem("About"));
        menubar.add(help);
        // Display the help menu in a special reserved place.
        menubar.setHelpMenu(help);
        
        // Create pushbuttons
        okay = new Button("Okay");
        cancel = new Button("Cancel");
        
        // Create a menu of choices
        choice = new Choice();
        choice.addItem("red");
        choice.addItem("green");
        choice.addItem("blue");
        
        // Create checkboxes, and group them.
        checkbox_group = new CheckboxGroup();
        checkboxes = new Checkbox[3];
        checkboxes[0] = new Checkbox("vanilla", checkbox_group, false);
        checkboxes[1] = new Checkbox("chocolate", checkbox_group, true);
        checkboxes[2] = new Checkbox("strawberry", checkbox_group, false);
        
        // Create a list of choices.
        list = new List(4, true);
        list.addItem("Java"); list.addItem("C"); list.addItem("C++");
        list.addItem("Smalltalk"); list.addItem("Lisp");
        list.addItem("Modula-3"); list.addItem("Forth");
        
        // Create a one-line text field, and multi-line text area.
        textfield = new TextField(15);
        textarea = new TextArea(6, 40);
        textarea.setEditable(false);
        
        // Create a scrolling canvas to scribble in. 
        scribble = new ScrollableScribble();
        
        // Create a file selection dialog box
        file_dialog = new FileDialog(this, "Open File", FileDialog.LOAD);
        
        // Create a Panel to contain all the components along the
        // left hand side of the window.  Use a GridBagLayout for it.
        panel1 = new Panel();
        panel1.setLayout(gridbag);
        
        // Use several versions of the constrain() convenience method
        // to add components to the panel and to specify their 
        // GridBagConstraints values.
        constrain(panel1, new Label("Name:"), 0, 0, 1, 1);
        constrain(panel1, textfield, 0, 1, 1, 1);
        constrain(panel1, new Label("Favorite color:"), 0, 2, 1, 1, 
              10, 0, 0, 0);
        constrain(panel1, choice, 0, 3, 1, 1);
        constrain(panel1, new Label("Favorite flavor:"), 0, 4, 1, 1, 
              10, 0, 0, 0);
        constrain(panel1, checkboxes[0], 0, 5, 1, 1);
        constrain(panel1, checkboxes[1], 0, 6, 1, 1);
        constrain(panel1, checkboxes[2], 0, 7, 1, 1);
        constrain(panel1, new Label("Favorite languages:"), 0, 8, 1, 1,
              10, 0, 0, 0);
        constrain(panel1, list, 0, 9, 1, 3, GridBagConstraints.VERTICAL,
              GridBagConstraints.NORTHWEST, 0.0, 1.0, 0, 0, 0, 0);
        
        // Create a panel for the items along the right side.
        // Use a GridBagLayout, and arrange items with constrain(), as above.
        panel2 = new Panel();
        panel2.setLayout(gridbag);
        
        constrain(panel2, new Label("Messages"), 0, 0, 1, 1);
        constrain(panel2, textarea, 0, 1, 1, 3, GridBagConstraints.HORIZONTAL,
              GridBagConstraints.NORTH, 1.0, 0.0, 0, 0, 0, 0);
        constrain(panel2, new Label("Diagram"), 0, 4, 1, 1, 10, 0, 0, 0);
        constrain(panel2, scribble, 0, 5, 1, 5, GridBagConstraints.BOTH,
              GridBagConstraints.CENTER, 1.0, 1.0, 0, 0, 0, 0);
        
        // Do the same for the buttons along the bottom.
        buttonpanel = new Panel();
        buttonpanel.setLayout(gridbag);
        constrain(buttonpanel, okay, 0, 0, 1, 1, GridBagConstraints.NONE,
              GridBagConstraints.CENTER, 0.3, 0.0, 0, 0, 0, 0);
        constrain(buttonpanel, cancel, 1, 0, 1, 1, GridBagConstraints.NONE,
              GridBagConstraints.CENTER, 0.3, 0.0, 0, 0, 0, 0);
        
        // Finally, use a GridBagLayout to arrange the panels themselves
        this.setLayout(gridbag);
        // And add the panels to the toplevel window
        constrain(this, panel1, 0, 0, 1, 1, GridBagConstraints.VERTICAL, 
              GridBagConstraints.NORTHWEST, 0.0, 1.0, 10, 10, 5, 5);
        constrain(this, panel2, 1, 0, 1, 1, GridBagConstraints.BOTH,
              GridBagConstraints.CENTER, 1.0, 1.0, 10, 10, 5, 10);
        constrain(this, buttonpanel, 0, 1, 2, 1, GridBagConstraints.HORIZONTAL,
              GridBagConstraints.CENTER, 1.0, 0.0, 5, 0, 0, 0);
    }
    
    public void constrain(Container container, Component component, 
                  int grid_x, int grid_y, int grid_width, int grid_height,
                  int fill, int anchor, double weight_x, double weight_y,
                  int top, int left, int bottom, int right)
    {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x; c.gridy = grid_y;
        c.gridwidth = grid_width; c.gridheight = grid_height;
        c.fill = fill; c.anchor = anchor;
        c.weightx = weight_x; c.weighty = weight_y;
        if (top+bottom+left+right > 0)
            c.insets = new Insets(top, left, bottom, right);
        
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }
    
    public void constrain(Container container, Component component, 
                  int grid_x, int grid_y, int grid_width, int grid_height) {
        constrain(container, component, grid_x, grid_y, 
              grid_width, grid_height, GridBagConstraints.NONE, 
              GridBagConstraints.NORTHWEST, 0.0, 0.0, 0, 0, 0, 0);
    }
    
    public void constrain(Container container, Component component, 
                  int grid_x, int grid_y, int grid_width, int grid_height,
                  int top, int left, int bottom, int right) {
        constrain(container, component, grid_x, grid_y, 
              grid_width, grid_height, GridBagConstraints.NONE, 
              GridBagConstraints.NORTHWEST, 
              0.0, 0.0, top, left, bottom, right);
    }
    
    public static void main(String[] args) {
        Frame f = new AllComponents("AWT Demo");
        // We should call f.pack() here.  But its buggy.
        f.resize(450, 475);
        f.show();
    }
}
