%   Change file for the MAKEPROG processor, for use with WEB to C.
%   This file was created for TANGLE by Howard Trickey and Pavel Curtis.
%       Modified for MAKEPROG by Klaus Guntermann at THD

% History:
%  10/9/82 (HT) Original version
%  11/29   (HT) New version, with conversion to lowercase handled properly
%               Also, new control sequence:
%                       @=...text...@>   Put ...text... verbatim on a line
%                                        by itself in the Pascal output.
%                                        (argument must fit on one line)
%               This control sequence facilitates putting #include "gcons.h"
%               (for example) in files meant for the pc compiler.
%               Also, changed command line usage, so that the absence of a
%               change file implies no change file, rather than one with the
%               same name as the web file, with .ch at the end.
%  1/15/83 (HT) Changed to work with version 1.2, which incorporates the
%               above change (though unbundling the output line breaking),
%               so mainly had to remove stuff.
%  2/17    (HT) Fixed bug that caused 0-9 in identifiers to be converted to
%               Q-Y on output.
%  3/18    (HT) Brought up to work with Version 1.5.  Added -r command line
%               flag to cause a .rpl file to be written with all the lines
%               of the .web file that were replaced because of the .ch file
%               (useful for comparing with previous .rpl files, to see if a
%               change file will still work with a new version of a .web file)
%               Also, made it write a newline just before exit.
%  4/12    (PC) Merged with Pavel's version, including adding a call to exit()
%               at the end depending upon the value of history.
%  4/16    (PC) Brought up to date with version 1.5 released April, 1983.
%  6/28   (HWT) Brought up to date with version 1.7 released June, 1983.
%    With new change file format, the -r option is now unnecessary.
%  7/17   (HWT) Brought up to date with version 2.0 released July, 1983.
% 12/18   (ETM) Brought up to date with version 2.5 released November, 1983.
% 11/7/84   (ETM) Brought up to date with version 2.6.
% 12/15/85 (ETM) Brought up to date with version 2.8.
%  3/ 7/88 (ETM) Converted for use with WEB2C
% 04/07/89 (-kg) Changed for MAKEPROG

% NOTE: The module numbers refer to the red-covered listing (Version 2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [0] WEAVE: print only changes
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 x
\pageno=\contentspagenumber \advance\pageno by 1
 y
\pageno=\contentspagenumber \advance\pageno by 1
\let\maybe=\iffalse
\def\title{TANGLE changes C}
 z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1] Change banner message
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d banner=='This is MAKEPROG, Version 1.0.1.'
@y
@d banner=='This is MAKEPROG, C Version 1.0.1.'
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [2] add input and output, remove other files, add ref to scan_args,
% [2]       and #include external definition for exit().
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d end_of_MAKEPROG = 9999 {go here to wrap it up}

@p @t\4@>@<Compiler directives@>@/
program MAKEPROG(@!doc_file,@!change_file,@!prog_file);
label end_of_MAKEPROG; {go here to finish}
const @<Constants in the outer block@>@;
type @<Types in the outer block@>@;
var @<Globals in the outer block@>@;
@t\4@>@<Error handling procedures@>@;
@y
@d end_of_MAKEPROG = 9999 {go here to wrap it up}
@d eof==feof

@p @t\4@>@<Compiler directives@>@/
program MAKEPROG;
label end_of_MAKEPROG; {go here to finish}
const @<Constants in the outer block@>@;
type @<Types in the outer block@>@;
var @<Globals in the outer block@>@;
@t\4@>@<Error handling procedures@>@;
@<Declaration of |scan_args|@>@/
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [4] compiler options
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@{@&@=$D-@> @} {no debug overhead}
@!debug @{@&@=$D+@> @}@+ gubed @; {but turn everything on when debugging}
@y
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [17] Allow tabs in input and output files
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
\MAKEPROG{} are allowed to have in their input files,
provided that unsuitable characters do not correspond to
special codes like |carriage_return| that are listed above.

@<Set init...@>=
for i:=1 to " "-1 do xchr[i]:=' ';
@y
\MAKEPROG{} are allowed to have in their input files,
provided that unsuitable characters do not correspond to
special codes like |carriage_return| that are listed above.
Here we add the tab character to the untranslated ones.
@<Set init...@>=
for i:=1 to " "-1 do xchr[i]:=' ';
xchr[tab_mark]:=chr(tab_mark);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [20] terminal output: use standard i/o
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d print(#)==write(term_out,#) {`|print|' means write on the terminal}
@y
@d term_out==stdout
@d print(#)==write(term_out,#) {`|print|' means write on the terminal}
@z

@x
@<Globals...@>=
@!term_out:text_file; {the terminal as an output file}
@y

@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [21] init terminal
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
Different systems have different ways of specifying that the
output on a certain file will appear on the user's terminal.
Here is one way to do this on the \PASCAL{} system that was
used in \.{TANGLE}'s initial development.
@^system dependencies@>

@<Set init...@>=
rewrite(term_out,'TTY:'); {send |term_out| output to the terminal}
@y
Different systems have different ways of specifying that the output on a
certain file will appear on the user's terminal.
@^system dependencies@>

@<Set init...@>=
 {Nothing need be done C}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [22] flush terminal buffer
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d update_terminal == break(term_out) {empty the terminal output buffer}
@y
@d update_terminal == flush(term_out) {empty the terminal output buffer}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [24] open input files
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
The following code opens the input files.  Since these files
were listed in the program header, we assume that the
\PASCAL\ runtime system has already checked that suitable
file names have been given; therefore no additional error
checking needs to be done.
@^system dependencies@>

@< Set init... @>=
reset(doc_file); reset(change_file);
@y
The following code opens the input files.
Use the |scan_args| procedure to fill the global file names,
according to the names given on the command line.
These globals, and the |scan_args| procedure will be defined at the end
where they won't disturb the module numbering.
@^system dependencies@>

@< Set init... @>=
scan_args;
reset(doc_file,doc_file_name); reset(change_file,change_file_name);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [26] open output files
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
The following code opens |prog_file|.  Since this file is
listed in the program header, we assume that the \PASCAL\
runtime system has checked that a suitable external file
name have been given.
@^system dependencies@>

@<Set init...@>=
rewrite(prog_file);
@y
The following code opens |prog_file|.
@^system dependencies@>

@<Set init...@>=
rewrite(prog_file,prog_file_name);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fix f^
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
   if eof(f) then input_ln:=false
   else  begin
      while not eoln(f) do
	 begin buffer[limit]:=xord[f^]; get(f);
	 incr(limit);
	 if (buffer[limit-1]<>" ") and (buffer[limit-1]<>tab_mark) then
	    final_limit:=limit;
	 if limit=buf_size then
	    begin while not eoln(f) do get(f);
@y
if eof(f) then input_ln:=false
else  begin while not eoln(f) do
    begin buffer[limit]:=xord[getc(f)];
    incr(limit);
    if (buffer[limit-1]<>" ") and (buffer[limit-1]<>tab_mark) then
	 final_limit:=limit;
    if limit=buf_size then
      begin while not eoln(f) do vgetc(f);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fix jump_out
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d fatal_error(#)==begin print_nl(#); error; mark_fatal; jump_out;
  end

@<Error handling...@>=
procedure jump_out;
begin goto end_of_MAKEPROG;
end;
@y
@d jump_out==uexit(1)
@d fatal_error(#)==begin new_line; print(#); error; mark_fatal; uexit(1);
  end
@z


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [182] write newline just before exit; use value of |history|
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
\noindent We have defined some procedures, and it is time to
use them---here is where \MAKEPROG{} starts, and where it
ends.
@^system dependencies@>
@y
\noindent We have defined some procedures, and it is time to
use them---here is where \MAKEPROG{} starts, and where it
ends.
@^system dependencies@>

@d UNIXexit==e@&x@&i@&t
@z

@x
   @<Print the job |history|@>;
@y
   @<Print the job |history|@>;
   new_line;
   if (history <> spotless) and (history <> harmless_message) then
      UNIXexit(1)
   else
      UNIXexit(0);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [188] system dependent changes--the |scan_args| procedure.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
\noindent This module should be replaced, if necessary, by
changes to the program that are necessary to make
\MAKEPROG{} work at a particular installation.	It is
usually best to design your change file so that all changes
to previous modules preserve the module numbering; then
everybody's version will be consistent with the printed
program.  More extensive changes, which introduce new
modules, can be inserted here; then only the index itself
will get a new module number.
@^system dependencies@>
@y
@^system dependencies@>

The user calls \.{MAKEPROG} with arguments on the command line.
These are either file names or flags (beginning with '-').
The following globals are for communicating the user's desires to the rest
of the program. The various |file_name| variables contain strings with
the full names of those files, as UNIX knows them.

There are no flags that affect \.{MAKEPROG} at the moment.

@d max_file_name_length=120
@d max_extension=5

@<Globals...@>=
@!doc_file_name,@!change_file_name,@!prog_file_name:
        array[1..max_file_name_length] of char;
@!prog_extension: array[1..max_file_name_length] of char;

@ The |scan_args| procedure looks at the command line arguments and sets
the |file_name| variables accordingly.
At least one file name must be present: the \.{DOC} file.  It may have
an extension, or it may omit it to get |'.doc'| added.
The output file name is formed by replacing the \.{DOC} file
name extension by |'.prg'|.
The output file will be created in the current directory.

If there is another file name present among the arguments, it is the
change file, again either with an extension or without one to get |'.ch'|
An omitted change file argument means that |'/dev/null'| should be used,
when no changes are desired.

@<Declaration of |scan_args|@>=
procedure scan_args;
var doc_dot_pos,dot_pos,i,a,slash_pos: integer; {indices}
c: char;
@!fname: array[1..max_file_name_length] of char; {temporary argument holder}
@!found_doc,@!found_change: boolean; {|true| when those file names have
                                        been seen}
begin
prog_extension[1]:='p';
prog_extension[2]:='r';
prog_extension[3]:='o';
prog_extension[4]:='g';
prog_extension[5]:=' ';
found_doc:=false;
found_change:=false;
for a:=1 to argc-1 do begin
        argv(a,fname); {put argument number |a| into |fname|}
        if fname[1]<>'-' then begin
		if not found_doc then
			@<Get |doc_file_name| and |prog_file_name|
				variables from |fname|@>
                else if not found_change then
                        @<Get |change_file_name| from |fname|@>
                else  @<Print usage error message and quit@>;
                end
        else @<Handle flag argument in |fname|@>;
        end;
if not found_doc then @<Print usage error message and quit@>;
@<Add the proper extension@>;
if not found_change then @<Set up null change file@>;
end;

@ Use all of |fname| for the |doc_file_name| if there is a |'.'| in it,
otherwise add |'.doc'|.
The other file names come from adding things after the dot.
If the name contained directory specifications, we reset the
dot occurred flag and do not use the directory part of the name
for the output files.
The |argv| procedure will not put more than
|max_file_name_length-max_extension|
characters into |fname|, and this leaves enough room in the |file_name|
variables to add the extensions.

The end of a file name is marked with a |' '|, the convention assumed by 
the |reset| and |rewrite| procedures.

@<Get |doc_file_name|...@>=
begin
slash_pos:=0;
dot_pos:=-1;
i:=1;
while (fname[i]<>' ') and (i<=max_file_name_length-max_extension) do begin
	doc_file_name[i]:=fname[i];
	if fname[i]='.' then dot_pos:=i else
	if fname[i]='/' then begin
	   slash_pos:=i; dot_pos:=-1; {reset}
	end;
	incr(i);
        end;
if dot_pos=-1 then begin
        dot_pos:=i;
	doc_file_name[dot_pos]:='.';
	doc_file_name[dot_pos+1]:='d';
	doc_file_name[dot_pos+2]:='o';
	doc_file_name[dot_pos+3]:='c';
	doc_file_name[dot_pos+4]:=' ';
        end;
dot_pos:=dot_pos-slash_pos; {may be unchanged if no slash}
for i:=1 to dot_pos do begin
	prog_file_name[i]:=
	   doc_file_name[i+slash_pos];
        end;
doc_dot_pos:=dot_pos;
found_doc:=true;
end

@ This section must be called when the doc file was found
and the doc dot position is determined.
@<Add the proper extension@>=
begin
i:=1;
if prog_extension[1]=' ' then prog_file_name[dot_pos]:=' '
else
while prog_extension[i]<>' ' do
begin prog_file_name[doc_dot_pos+i]:=prog_extension[i];
	i:=i+1;
end;
end

@ @<Get |change_file_name|...@>=
begin
dot_pos:=-1;
i:=1;
while (fname[i]<>' ') and (i<=max_file_name_length-max_extension)
do begin
        change_file_name[i]:=fname[i];
	if fname[i]='.' then dot_pos:=i else
	if fname[i]='/' then dot_pos:=-1;
        incr(i);
        end;
if dot_pos=-1 then begin
        dot_pos:=i;
        change_file_name[dot_pos]:='.';
        change_file_name[dot_pos+1]:='c';
        change_file_name[dot_pos+2]:='h';
        change_file_name[dot_pos+3]:=' ';
        end;
found_change:=true;
end

@ @<Set up null...@>=
begin
        change_file_name[1]:='/';
        change_file_name[2]:='d';
        change_file_name[3]:='e';
        change_file_name[4]:='v';
        change_file_name[5]:='/';
        change_file_name[6]:='n';
        change_file_name[7]:='u';
        change_file_name[8]:='l';
        change_file_name[9]:='l';
        change_file_name[10]:=' ';
end

@ \.{MAKEPROG} accepts the intended extension of a created file as an
option to overwrite the default extension 'prog'.

@<Handle flag...@>=
begin
  i:=1;
  while (i<max_extension+1) and (fname[i+1]<>' ') do
  begin
	prog_extension[i]:=fname[i+1];
	i:=i+1;
  end;
  prog_extension[i]:=' ';
  if i>max_extension then
       @<Print usage error message and quit@>;
end

@ @<Print usage error message and quit@>=
begin
print_nl('! Usage: makeprog [-progext] docfile[.doc] [changefile[.ch]]');
error;
jump_out;
end

@z
