/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.stream;

import korlibs.io.lang.ExceptionsKt;
import korlibs.io.stream.AsyncStreamBase;
import korlibs.memory.ArraysKt;
import korlibs.memory.ByteArrayBuilder;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0011\u0010\u0014\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0016\u001a\u00020\u0013H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J1\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0019\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0013H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J1\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0007R$\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lkorlibs/io/stream/MemoryAsyncStreamBase;", "Lkorlibs/io/stream/AsyncStreamBase;", "initialCapacity", "", "(I)V", "data", "Lkorlibs/memory/ByteArrayBuilder;", "(Lkorlibs/memory/ByteArrayBuilder;)V", "getData", "()Lkorlibs/memory/ByteArrayBuilder;", "setData", "value", "ilength", "getIlength", "()I", "setIlength", "checkPosition", "", "position", "", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLength", "read", "buffer", "", "offset", "len", "(J[BIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setLength", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "", "write", "korio"})
public final class MemoryAsyncStreamBase
extends AsyncStreamBase {
    @NotNull
    private ByteArrayBuilder data;

    public MemoryAsyncStreamBase(@NotNull ByteArrayBuilder data) {
        this.data = data;
    }

    @NotNull
    public final ByteArrayBuilder getData() {
        return this.data;
    }

    public final void setData(@NotNull ByteArrayBuilder byteArrayBuilder) {
        this.data = byteArrayBuilder;
    }

    public MemoryAsyncStreamBase(int initialCapacity) {
        this(new ByteArrayBuilder(initialCapacity));
    }

    public /* synthetic */ MemoryAsyncStreamBase(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4096;
        }
        this(n);
    }

    public final int getIlength() {
        return this.data.getSize();
    }

    public final void setIlength(int value) {
        this.data.setSize(value);
    }

    @Override
    @Nullable
    public Object setLength(long value, @NotNull Continuation<? super Unit> $completion) {
        this.setIlength((int)value);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getLength(@NotNull Continuation<? super Long> $completion) {
        return Boxing.boxLong(this.getIlength());
    }

    public final void checkPosition(long position) {
        if (position < 0L) {
            ExceptionsKt.invalidOp("Invalid position " + position);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @Nullable
    public Object read(long position, @NotNull byte[] buffer, int offset, int len, @NotNull Continuation<? super Integer> $completion) {
        this.checkPosition(position);
        if (!(0L <= position ? position < (long)this.getIlength() : false)) {
            return Boxing.boxInt(0);
        }
        long end2 = Math.min((long)this.getIlength(), position + (long)len);
        int actualLen = Math.max((int)(end2 - position), 0);
        ArraysKt.arraycopy(this.data.getData(), (int)position, buffer, offset, actualLen);
        return Boxing.boxInt(actualLen);
    }

    @Override
    @Nullable
    public Object write(long position, @NotNull byte[] buffer, int offset, int len, @NotNull Continuation<? super Unit> $completion) {
        this.checkPosition(position);
        this.data.setSize(Math.max(this.data.getSize(), (int)(position + (long)len)));
        ArraysKt.arraycopy(buffer, offset, this.data.getData(), (int)position, len);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        return "MemoryAsyncStreamBase(" + this.data.getSize() + ')';
    }
}

