/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ScreenShooter {
    private static void loadWebPage(String url) {
        try {
            Desktop.getDesktop().browse(new URL(url).toURI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void closeWebPage(int delay) {
        try {
            Thread.sleep(delay);
            Robot robot = new Robot();
            robot.keyPress(17);
            robot.keyPress(87);
            robot.keyRelease(17);
            robot.keyRelease(87);
        }
        catch (AWTException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void captureScreenshot(String url, int width, int height, String fileName, String path) {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ScreenShooter.loadWebPage(url);
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Robot robot = new Robot();
            Rectangle area = new Rectangle(screenSize.width, screenSize.height);
            BufferedImage screenshot = robot.createScreenCapture(area);
            ImageIO.write((RenderedImage)screenshot, "png", new File(path + fileName + ".png"));
            ScreenShooter.closeWebPage(2000);
            System.out.println("Screenshot saved at: " + path + fileName + ".png");
            System.out.println("Screenshot saved: " + fileName + ".png");
        }
        catch (AWTException | IOException e) {
            e.printStackTrace();
        }
    }

    private static void resizeImage(int scaledWidth, int scaledHeight, String fileName) throws IOException {
        File inputFile = new File(System.getProperty("user.dir") + "/" + fileName + ".png");
        BufferedImage inputImage = ImageIO.read(inputFile);
        BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
        Graphics2D graphics2D = outputImage.createGraphics();
        graphics2D.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
        graphics2D.dispose();
        ImageIO.write((RenderedImage)outputImage, "png", new File(fileName + ".png"));
    }
}

