/* lstring.c - 21:05 GMT +10:00 Tue 11 May 1993 - Geoffrey Tobin */
/* Length (and capacity) specified strings. */

#include "new.h"
#include "lstring.h"

#ifdef __STDC__
LString * NewLString (int capacity)
#else
LString * NewLString (capacity)
  int capacity;
#endif
{
  LString * S = New (LString);
  if (S != NULL)
  {
    S->cap = capacity;
    S->len = 0;
    S->s = (capacity < 0 ? NULL : cnew (capacity+1, char));
    if (S->s != NULL)
      S->s[0] = S->s[capacity] = '\0';  /* safeguard */
  }
  return S;
}
/* NewLString */

#ifdef __STDC__
LString * FreeLString (LString * S)
#else
LString * FreeLString (S)
  LString * S;
#endif
{
  Free (S, LString);
  return S;
}
/* FreeLString */

#ifdef __STDC__
Void Scovers (LString * S, int l, const char * s)
#else
Void Scovers (S, l, s)
  LString * S;  int l;  char * s;
#endif
{
  if (S != NULL)
  {
    int c = S->cap;
    char * t = S->s;
    strncpy (t+l, s, c-l);
    t[c] = '\0';  /* to be safe */
    S->len = strlen (t);
  }
}
/* Scovers */

#ifdef __STDC__
Void Scopys (LString * S, const char * s)
#else
Void Scopys (S, s)
  LString * S;  char * s;
#endif
{
  Scovers (S, 0, s);
}
/* Scopys */

#ifdef __STDC__
Void Scats (LString * S, const char * s)
#else
Void Scats (S, s)
  LString * S;  char * s;
#endif
{
  if (S != NULL)
    Scovers (S, S->len, s);
}
/* Scats */

/* end lstring.c */
