{$W-,R+,V-,G+}
unit wbibjpeg;

interface

Uses
  WinTypes,WinProcs,WObjects,wbibGUI,rc_id,graphio,bibstrg,wbibdisp;

const
{ ECJ callback messages }
  ECJ_RESOLUTION = 0;
  ECJ_PROGRESS	 = 1;
  ECJ_ERROR	     = 2;


{ ECJ_Decode attributes }
  ECJ_HALF_SIZE	= $0001;
  ECJ_AUTO_HALF	= $0002;
  ECJ_GRAY_ONLY	= $0004;
  ECJ_2_PASS	  = $0008;
  ECJ_DITHER	  = $0010;
  ECJ_24_BITS	  = $0020;

	{ ECJ function prototypes }
type
  TECJ_Callback = function(mMsg,wParam: word; lParam: longint): integer;
  PECJ_Callback = ^TECJ_Callback;
  TECJ_Decode   = function(lpstrFileName: PChar; wParam: word; lParam: Longint;
                           lpfnECJ_CallBack: PECJ_Callback): THandle;
  TECJ_DecodeMem= function(hStream: THandle; dwStreamLen: longint;
                           wParam: word; lParam: Longint;
                           lpfnECJ_CallBack: TECJ_Callback): THandle;

{ ECJ macros }
function Get_ECJ_Video_Format(x: longint): longint;
function Get_ECJ_Half_Size(x: longint): longint;
function Get_ECJ_X(x: longint): word;
function Get_ECJ_Y(x: longint): longint;

function LoadJPEGDIB(Window: PWindowsObject;
              Name: PChar; var Width,Height: longint): THandle;

var
  ECJ_Active,GaveDLLWarning: boolean;

implementation

var
  ECJ_Module: THandle;
  OldExitProc: Pointer;
  ECJ_Decode: TFarProc;

function Get_ECJ_Video_Format(x: longint): longint;
begin Get_ECJ_Video_Format:=(x and $0007); end;

function Get_ECJ_Half_Size(x: longint): longint;
begin Get_ECJ_Half_Size := (x and $0008); end;

function Get_ECJ_X(x: longint): word;
begin Get_ECJ_X := HiWord(x); end;

function Get_ECJ_Y(x: longint): longint;
begin Get_ECJ_Y := LoWord(x); end;

function LoadJPEGDIB(Window: PWindowsObject;
              Name: PChar; var Width,Height: longint): THandle;
var
  DIB: Thandle;
  BInfoHeader: PBitmapInfoHeader;
begin
  LoadJPEGDIB:=0; Width:=0; Height:=0; DIB:=0;
  if ECJ_Module=0 then
  begin
    if not GaveDLLWarning then
      Application^.ExecDialog(New(PDialog,init(Window,PChar(rc_MissingJPEGDLL))));
    GaveDLLWarning:=true;
    Exit;
  end;
  if (Name=Nil) or (Name[0]=#0) then Exit;
  DIB:=TECJ_Decode(ECJ_Decode)(Name,0,0,Nil);
  if DIB=0 then Exit;

  BInfoHeader:=GlobalLock(DIB);
  Width :=BInfoHeader^.biWidth;
  Height:=BInfoHeader^.biHeight;
  GlobalUnlock(DIB);
  LoadJPEGDIB:=DIB;
end;                  { LoadJPEGDIB }

procedure UnloadECJModule; far;
begin
  ExitProc:=OldExitProc;
  if ECJ_Module<>0 then FreeLibrary(ECJ_Module);
end;

const
  SEM_NoOpenFileErrorBox = $8000;
var
  PrevErrorMode: word;
begin
  ECJ_Active:=false; GaveDLLWarning:=false;
  PrevErrorMode:=SetErrorMode(SEM_NoOpenFileErrorBox);
  ECJ_Module:=LoadLibrary('wecjlib.dll');
  SetErrorMode(PrevErrorMode);
  if ECJ_Module<22 then ECJ_Module:=0
  else begin
    OldExitProc:=ExitProc; ExitProc:=@UnloadECJModule;
    ECJ_Decode:=GetProcAddress(ECJ_Module,'ECJ_Decode');
    ECJ_Active:=true;
  end;
end.